/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.federation;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;

public class FederationConnectionConfiguration
implements Serializable {
    public static long DEFAULT_CIRCUIT_BREAKER_TIMEOUT = 30000L;
    private boolean isHA;
    private String discoveryGroupName;
    private List<String> staticConnectors;
    private int priorityAdjustment;
    private long circuitBreakerTimeout = DEFAULT_CIRCUIT_BREAKER_TIMEOUT;
    private String username;
    private String password;
    private boolean shareConnection;
    private long clientFailureCheckPeriod = ActiveMQDefaultConfiguration.getDefaultFederationFailureCheckPeriod();
    private long connectionTTL = ActiveMQDefaultConfiguration.getDefaultFederationConnectionTtl();
    private long retryInterval = ActiveMQDefaultConfiguration.getDefaultFederationRetryInterval();
    private double retryIntervalMultiplier = ActiveMQDefaultConfiguration.getDefaultFederationRetryIntervalMultiplier();
    private long maxRetryInterval = ActiveMQDefaultConfiguration.getDefaultFederationMaxRetryInterval();
    private int initialConnectAttempts = ActiveMQDefaultConfiguration.getDefaultFederationInitialConnectAttempts();
    private int reconnectAttempts = ActiveMQDefaultConfiguration.getDefaultFederationReconnectAttempts();
    private long callTimeout = ActiveMQDefaultConfiguration.getDefaultFederationCallTimeout();
    private long callFailoverTimeout = ActiveMQDefaultConfiguration.getDefaultFederationCallFailoverTimeout();

    public String getDiscoveryGroupName() {
        return this.discoveryGroupName;
    }

    public FederationConnectionConfiguration setDiscoveryGroupName(String discoveryGroupName) {
        this.discoveryGroupName = discoveryGroupName;
        return this;
    }

    public List<String> getStaticConnectors() {
        return this.staticConnectors;
    }

    public FederationConnectionConfiguration setStaticConnectors(List<String> staticConnectors) {
        this.staticConnectors = staticConnectors;
        return this;
    }

    public boolean isHA() {
        return this.isHA;
    }

    public FederationConnectionConfiguration setHA(boolean HA) {
        this.isHA = HA;
        return this;
    }

    public long getCircuitBreakerTimeout() {
        return this.circuitBreakerTimeout;
    }

    public FederationConnectionConfiguration setCircuitBreakerTimeout(long circuitBreakerTimeout) {
        this.circuitBreakerTimeout = circuitBreakerTimeout;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public FederationConnectionConfiguration setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public FederationConnectionConfiguration setPassword(String password) {
        this.password = password;
        return this;
    }

    public int getPriorityAdjustment() {
        return this.priorityAdjustment;
    }

    public FederationConnectionConfiguration setPriorityAdjustment(int priorityAdjustment) {
        this.priorityAdjustment = priorityAdjustment;
        return this;
    }

    public boolean isShareConnection() {
        return this.shareConnection;
    }

    public FederationConnectionConfiguration setShareConnection(boolean shareConnection) {
        this.shareConnection = shareConnection;
        return this;
    }

    public long getClientFailureCheckPeriod() {
        return this.clientFailureCheckPeriod;
    }

    public FederationConnectionConfiguration setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
        return this;
    }

    public long getConnectionTTL() {
        return this.connectionTTL;
    }

    public FederationConnectionConfiguration setConnectionTTL(long connectionTTL) {
        this.connectionTTL = connectionTTL;
        return this;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public FederationConnectionConfiguration setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
        return this;
    }

    public double getRetryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    public FederationConnectionConfiguration setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        return this;
    }

    public long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public FederationConnectionConfiguration setMaxRetryInterval(long maxRetryInterval) {
        this.maxRetryInterval = maxRetryInterval;
        return this;
    }

    public int getInitialConnectAttempts() {
        return this.initialConnectAttempts;
    }

    public FederationConnectionConfiguration setInitialConnectAttempts(int initialConnectAttempts) {
        this.initialConnectAttempts = initialConnectAttempts;
        return this;
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public FederationConnectionConfiguration setReconnectAttempts(int reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
        return this;
    }

    public long getCallTimeout() {
        return this.callTimeout;
    }

    public FederationConnectionConfiguration setCallTimeout(long callTimeout) {
        this.callTimeout = callTimeout;
        return this;
    }

    public long getCallFailoverTimeout() {
        return this.callFailoverTimeout;
    }

    public FederationConnectionConfiguration setCallFailoverTimeout(long callFailoverTimeout) {
        this.callFailoverTimeout = callFailoverTimeout;
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FederationConnectionConfiguration)) {
            return false;
        }
        FederationConnectionConfiguration other = (FederationConnectionConfiguration)obj;
        return this.clientFailureCheckPeriod == other.clientFailureCheckPeriod && this.connectionTTL == other.connectionTTL && this.retryInterval == other.retryInterval && Double.compare(other.retryIntervalMultiplier, this.retryIntervalMultiplier) == 0 && this.maxRetryInterval == other.maxRetryInterval && this.initialConnectAttempts == other.initialConnectAttempts && this.reconnectAttempts == other.reconnectAttempts && this.callTimeout == other.callTimeout && this.callFailoverTimeout == other.callFailoverTimeout && this.isHA == other.isHA && this.priorityAdjustment == other.priorityAdjustment && this.circuitBreakerTimeout == other.circuitBreakerTimeout && this.shareConnection == other.shareConnection && Objects.equals(this.discoveryGroupName, other.discoveryGroupName) && Objects.equals(this.staticConnectors, other.staticConnectors) && Objects.equals(this.username, other.username) && Objects.equals(this.password, other.password);
    }

    public int hashCode() {
        return Objects.hash(this.clientFailureCheckPeriod, this.connectionTTL, this.retryInterval, this.retryIntervalMultiplier, this.maxRetryInterval, this.initialConnectAttempts, this.reconnectAttempts, this.callTimeout, this.callFailoverTimeout, this.isHA, this.discoveryGroupName, this.staticConnectors, this.priorityAdjustment, this.circuitBreakerTimeout, this.username, this.password, this.shareConnection);
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeNullableString(this.username);
        buffer.writeNullableString(this.password);
        buffer.writeBoolean(this.shareConnection);
        buffer.writeInt(this.priorityAdjustment);
        buffer.writeLong(this.clientFailureCheckPeriod);
        buffer.writeLong(this.connectionTTL);
        buffer.writeLong(this.retryInterval);
        buffer.writeDouble(this.retryIntervalMultiplier);
        buffer.writeLong(this.retryInterval);
        buffer.writeInt(this.initialConnectAttempts);
        buffer.writeInt(this.reconnectAttempts);
        buffer.writeLong(this.callTimeout);
        buffer.writeLong(this.callFailoverTimeout);
    }

    public void decode(ActiveMQBuffer buffer) {
        this.username = buffer.readNullableString();
        this.password = buffer.readNullableString();
        this.shareConnection = buffer.readBoolean();
        this.priorityAdjustment = buffer.readInt();
        this.clientFailureCheckPeriod = buffer.readLong();
        this.connectionTTL = buffer.readLong();
        this.retryInterval = buffer.readLong();
        this.retryIntervalMultiplier = buffer.readDouble();
        this.maxRetryInterval = buffer.readLong();
        this.initialConnectAttempts = buffer.readInt();
        this.reconnectAttempts = buffer.readInt();
        this.callTimeout = buffer.readLong();
        this.callFailoverTimeout = buffer.readLong();
    }
}

