/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.AttributeMethods;
import org.springframework.lang.Contract;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ObjectUtils;

public abstract class RepeatableContainers {
    static final Map<Class<? extends Annotation>, Object> cache = new ConcurrentReferenceHashMap<Class<? extends Annotation>, Object>();
    @Nullable
    private final RepeatableContainers parent;

    private RepeatableContainers(@Nullable RepeatableContainers parent) {
        this.parent = parent;
    }

    public RepeatableContainers and(Class<? extends Annotation> container, Class<? extends Annotation> repeatable) {
        return new ExplicitRepeatableContainer(this, repeatable, container);
    }

    @Nullable
    Annotation[] findRepeatedAnnotations(Annotation annotation) {
        if (this.parent == null) {
            return null;
        }
        return this.parent.findRepeatedAnnotations(annotation);
    }

    @Contract(value="null -> false")
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.parent, ((RepeatableContainers)other).parent);
    }

    public int hashCode() {
        return Objects.hashCode(this.parent);
    }

    public static RepeatableContainers standardRepeatables() {
        return StandardRepeatableContainers.INSTANCE;
    }

    public static RepeatableContainers of(Class<? extends Annotation> repeatable, @Nullable Class<? extends Annotation> container) {
        return new ExplicitRepeatableContainer(null, repeatable, container);
    }

    public static RepeatableContainers none() {
        return NoRepeatableContainers.INSTANCE;
    }

    private static class ExplicitRepeatableContainer
    extends RepeatableContainers {
        private final Class<? extends Annotation> repeatable;
        private final Class<? extends Annotation> container;
        private final Method valueMethod;

        ExplicitRepeatableContainer(@Nullable RepeatableContainers parent, Class<? extends Annotation> repeatable, @Nullable Class<? extends Annotation> container) {
            super(parent);
            Assert.notNull(repeatable, "Repeatable must not be null");
            if (container == null) {
                container = this.deduceContainer(repeatable);
            }
            Method valueMethod = AttributeMethods.forAnnotationType(container).get("value");
            try {
                if (valueMethod == null) {
                    throw new NoSuchMethodException("No value method found");
                }
                Class<?> returnType = valueMethod.getReturnType();
                if (!returnType.isArray() || returnType.componentType() != repeatable) {
                    throw new AnnotationConfigurationException("Container type [%s] must declare a 'value' attribute for an array of type [%s]".formatted(container.getName(), repeatable.getName()));
                }
            }
            catch (AnnotationConfigurationException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new AnnotationConfigurationException("Invalid declaration of container type [%s] for repeatable annotation [%s]".formatted(container.getName(), repeatable.getName()), ex);
            }
            this.repeatable = repeatable;
            this.container = container;
            this.valueMethod = valueMethod;
        }

        private Class<? extends Annotation> deduceContainer(Class<? extends Annotation> repeatable) {
            Repeatable annotation = repeatable.getAnnotation(Repeatable.class);
            Assert.notNull((Object)annotation, () -> "Annotation type must be a repeatable annotation: failed to resolve container type for " + repeatable.getName());
            return annotation.value();
        }

        @Override
        @Nullable
        Annotation[] findRepeatedAnnotations(Annotation annotation) {
            if (this.container.isAssignableFrom(annotation.annotationType())) {
                return (Annotation[])AnnotationUtils.invokeAnnotationMethod(this.valueMethod, annotation);
            }
            return super.findRepeatedAnnotations(annotation);
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (!super.equals(other)) {
                return false;
            }
            ExplicitRepeatableContainer otherErc = (ExplicitRepeatableContainer)other;
            return this.container.equals(otherErc.container) && this.repeatable.equals(otherErc.repeatable);
        }

        @Override
        public int hashCode() {
            int hashCode = super.hashCode();
            hashCode = 31 * hashCode + this.container.hashCode();
            hashCode = 31 * hashCode + this.repeatable.hashCode();
            return hashCode;
        }
    }

    private static class StandardRepeatableContainers
    extends RepeatableContainers {
        private static final Object NONE = new Object();
        private static final StandardRepeatableContainers INSTANCE = new StandardRepeatableContainers();

        StandardRepeatableContainers() {
            super(null);
        }

        @Override
        @Nullable
        Annotation[] findRepeatedAnnotations(Annotation annotation) {
            Method method = StandardRepeatableContainers.getRepeatedAnnotationsMethod(annotation.annotationType());
            if (method != null) {
                return (Annotation[])AnnotationUtils.invokeAnnotationMethod(method, annotation);
            }
            return super.findRepeatedAnnotations(annotation);
        }

        @Nullable
        private static Method getRepeatedAnnotationsMethod(Class<? extends Annotation> annotationType) {
            Object result = cache.computeIfAbsent(annotationType, StandardRepeatableContainers::computeRepeatedAnnotationsMethod);
            return result != NONE ? (Method)result : null;
        }

        private static Object computeRepeatedAnnotationsMethod(Class<? extends Annotation> annotationType) {
            TypeDescriptor.OfField componentType;
            Class<?> returnType;
            AttributeMethods methods = AttributeMethods.forAnnotationType(annotationType);
            Method method = methods.get("value");
            if (method != null && (returnType = method.getReturnType()).isArray() && Annotation.class.isAssignableFrom((Class<?>)(componentType = returnType.componentType())) && ((Class)componentType).isAnnotationPresent(Repeatable.class)) {
                return method;
            }
            return NONE;
        }
    }

    private static class NoRepeatableContainers
    extends RepeatableContainers {
        private static final NoRepeatableContainers INSTANCE = new NoRepeatableContainers();

        NoRepeatableContainers() {
            super(null);
        }
    }
}

