/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl.jdbc;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

interface LeaseLock
extends AutoCloseable {
    public long localExpirationTime();

    default public long expirationMillis() {
        return Long.MAX_VALUE;
    }

    default public boolean renew() {
        return true;
    }

    public boolean tryAcquire();

    default public AcquireResult tryAcquire(ExitCondition exitCondition, Pauser pauser) {
        while (exitCondition.keepRunning()) {
            if (this.tryAcquire()) {
                return AcquireResult.Done;
            }
            pauser.idle();
        }
        return AcquireResult.Exit;
    }

    default public AcquireResult tryAcquire(long tryAcquireTimeoutMillis, Pauser pauser, ExitCondition exitCondition) {
        if (tryAcquireTimeoutMillis < 0L) {
            return this.tryAcquire(exitCondition, pauser);
        }
        long timeoutInNanosecond = TimeUnit.MILLISECONDS.toNanos(tryAcquireTimeoutMillis);
        long startAcquire = System.nanoTime();
        while (exitCondition.keepRunning()) {
            if (this.tryAcquire()) {
                return AcquireResult.Done;
            }
            if (System.nanoTime() - startAcquire >= timeoutInNanosecond) {
                return AcquireResult.Timeout;
            }
            pauser.idle();
            if (System.nanoTime() - startAcquire < timeoutInNanosecond) continue;
            return AcquireResult.Timeout;
        }
        return AcquireResult.Exit;
    }

    public boolean isHeld();

    public boolean isHeldByCaller();

    @Override
    default public void close() throws Exception {
        this.release();
    }

    public void release();

    public static interface ExitCondition {
        public boolean keepRunning();
    }

    public static enum AcquireResult {
        Timeout,
        Exit,
        Done;

    }

    public static interface Pauser {
        public void idle();

        public static Pauser sleep(long idleTime, TimeUnit timeUnit) {
            long idleNanos = timeUnit.toNanos(idleTime);
            return () -> LockSupport.parkNanos(idleNanos);
        }

        public static Pauser noWait() {
            return () -> {};
        }
    }
}

