/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.tls.impl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.opensaml.security.x509.tls.impl.ThreadLocalX509TrustEngineSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocalX509TrustManager
implements X509TrustManager {
    private Logger log = LoggerFactory.getLogger(ThreadLocalX509TrustManager.class);

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.performTrustEval(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.performTrustEval(chain, authType);
    }

    protected void performTrustEval(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("Certificate chain was null or empty");
        }
        if (authType == null || authType.isEmpty()) {
            throw new IllegalArgumentException("AuthType was null or empty");
        }
        this.log.trace("Evaluating certificate chain against ThreadLocalX509TrustEngineContext data");
        ThreadLocalX509TrustEngineSupport.evaluate(chain);
    }
}

