/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.impl.PageReadWriter;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.utils.ReferenceCounterUtil;
import org.apache.activemq.artemis.utils.collections.EmptyList;
import org.apache.activemq.artemis.utils.collections.LinkedList;
import org.apache.activemq.artemis.utils.collections.LinkedListImpl;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Page {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final AtomicInteger factory = new AtomicInteger(0);
    private final int seqInt = Page.factory.incrementAndGet();
    private final ReferenceCounterUtil referenceCounter = new ReferenceCounterUtil();
    private final long pageId;
    private boolean suspiciousRecords = false;
    private volatile int numberOfMessages;
    private final SequentialFile file;
    private final SequentialFileFactory fileFactory;
    private volatile LinkedList<PagedMessage> messages;
    private volatile long size;
    private final StorageManager storageManager;
    private final SimpleString storeName;
    private ByteBuffer readFileBuffer;

    public void usageExhaust() {
        this.referenceCounter.exhaust();
    }

    public int usageUp() {
        return this.referenceCounter.increment();
    }

    public int usageDown() {
        return this.referenceCounter.decrement();
    }

    public void releaseTask(Consumer<Page> releaseTask) {
        this.referenceCounter.setTask(() -> releaseTask.accept(this));
    }

    public Page(SimpleString storeName, StorageManager storageManager, SequentialFileFactory factory, SequentialFile file, long pageId) throws Exception {
        this.pageId = pageId;
        this.file = file;
        this.fileFactory = factory;
        this.storageManager = storageManager;
        this.storeName = storeName;
    }

    public long getPageId() {
        return this.pageId;
    }

    public LinkedListIterator<PagedMessage> iterator() throws Exception {
        LinkedList<PagedMessage> messages = this.getMessages();
        return messages.iterator();
    }

    public synchronized LinkedList<PagedMessage> getMessages() throws Exception {
        if (this.messages == null) {
            boolean wasOpen = this.file.isOpen();
            if (!wasOpen) {
                if (!this.file.exists()) {
                    return EmptyList.getEmptyList();
                }
                this.file.open();
            }
            this.messages = this.read(this.storageManager);
            if (!wasOpen) {
                this.file.close();
            }
        }
        return this.messages;
    }

    private void addMessage(PagedMessage message) {
        if (this.messages == null) {
            this.messages = new LinkedListImpl();
        }
        message.setMessageNumber(this.messages.size());
        message.setPageNumber(this.pageId);
        this.messages.addTail((Object)message);
    }

    public synchronized LinkedList<PagedMessage> read() throws Exception {
        return this.read(this.storageManager);
    }

    public synchronized LinkedList<PagedMessage> read(StorageManager storage) throws Exception {
        return this.read(storage, false);
    }

    public synchronized LinkedList<PagedMessage> read(StorageManager storage, boolean onlyLargeMessages) throws Exception {
        if (!this.file.isOpen()) {
            if (!this.file.exists()) {
                return EmptyList.getEmptyList();
            }
            throw ActiveMQMessageBundle.BUNDLE.invalidPageIO();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("reading page {} on address = {} onlyLargeMessages = {}", new Object[]{this.pageId, this.storeName, onlyLargeMessages, new Exception("trace")});
        } else if (logger.isDebugEnabled()) {
            logger.debug("reading page {} on address = {} onlyLargeMessages = {}", new Object[]{this.pageId, this.storeName, onlyLargeMessages});
        }
        this.size = this.file.size();
        LinkedListImpl messages = new LinkedListImpl();
        this.numberOfMessages = PageReadWriter.readFromSequentialFile(storage, this.storeName, this.fileFactory, this.file, this.pageId, arg_0 -> ((LinkedList)messages).addTail(arg_0), onlyLargeMessages ? PageReadWriter.ONLY_LARGE : PageReadWriter.NO_SKIP, this::markFileAsSuspect, this::setSize);
        return messages;
    }

    public String debugMessages() throws Exception {
        StringBuffer buffer = new StringBuffer();
        LinkedListIterator iter = this.getMessages().iterator();
        while (iter.hasNext()) {
            PagedMessage message = (PagedMessage)iter.next();
            buffer.append(message.toString() + "\n");
        }
        iter.close();
        return buffer.toString();
    }

    public synchronized void write(PagedMessage message) throws Exception {
        this.writeDirect(message);
        this.storageManager.pageWrite(message, this.pageId);
    }

    public synchronized void writeDirect(PagedMessage message) throws Exception {
        if (!this.file.isOpen()) {
            throw ActiveMQMessageBundle.BUNDLE.cannotWriteToClosedFile(this.file);
        }
        this.addMessage(message);
        this.size += (long)PageReadWriter.writeMessage(message, this.fileFactory, this.file);
        ++this.numberOfMessages;
    }

    public void sync() throws Exception {
        this.file.sync();
    }

    public void trySync() throws IOException {
        try {
            if (this.file.isOpen()) {
                this.file.sync();
            }
        }
        catch (IOException e) {
            if (e instanceof ClosedChannelException) {
                logger.debug("file.sync on file {} thrown a ClosedChannelException that will just be ignored", (Object)this.file.getFileName());
            }
            throw e;
        }
    }

    public boolean isOpen() {
        return this.file != null && this.file.isOpen();
    }

    public boolean open(boolean createFile) throws Exception {
        boolean isOpen = false;
        if (!this.file.isOpen() && (createFile || this.file.exists())) {
            this.file.open();
            isOpen = true;
        }
        if (this.file.isOpen()) {
            isOpen = true;
            this.size = this.file.size();
            this.file.position(0L);
        }
        return isOpen;
    }

    public void close(boolean sendReplicaClose) throws Exception {
        this.close(sendReplicaClose, true);
    }

    public synchronized void close(boolean sendReplicaClose, boolean waitSync) throws Exception {
        if (this.readFileBuffer != null) {
            this.fileFactory.releaseDirectBuffer(this.readFileBuffer);
            this.readFileBuffer = null;
        }
        if (sendReplicaClose && this.storageManager != null) {
            this.storageManager.pageClosed(this.storeName, this.pageId);
        }
        this.file.close(waitSync, waitSync);
    }

    public boolean delete(LinkedList<PagedMessage> messages) throws Exception {
        if (this.storageManager != null) {
            this.storageManager.pageDeleted(this.storeName, this.pageId);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Deleting pageNr={} on store {}", new Object[]{this.pageId, this.storeName, new Exception("trace")});
        } else if (logger.isDebugEnabled()) {
            logger.debug("Deleting pageNr={} on store {}", (Object)this.pageId, (Object)this.storeName);
        }
        if (messages != null) {
            try (LinkedListIterator iter = messages.iterator();){
                while (iter.hasNext()) {
                    PagedMessage msg = (PagedMessage)iter.next();
                    if (!msg.getMessage().isLargeMessage()) continue;
                    ((LargeServerMessage)msg.getMessage()).deleteFile();
                    msg.getMessage().usageDown();
                }
            }
        }
        this.storageManager.afterCompleteOperations(new IOCallback(){

            public void done() {
                try {
                    if (Page.this.suspiciousRecords) {
                        ActiveMQServerLogger.LOGGER.pageInvalid(Page.this.file.getFileName(), Page.this.file.getFileName());
                        Page.this.file.renameTo(Page.this.file.getFileName() + ".invalidPage");
                    } else {
                        Page.this.file.delete();
                    }
                    Page.this.referenceCounter.exhaust();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.pageDeleteError(e);
                }
            }

            public void onError(int errorCode, String errorMessage) {
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readNumberOfMessages() throws Exception {
        boolean wasOpen = this.isOpen();
        if (!wasOpen && !this.open(false)) {
            return 0;
        }
        try {
            int numberOfMessages = PageReadWriter.readFromSequentialFile(this.storageManager, this.storeName, this.fileFactory, this.file, this.pageId, null, PageReadWriter.SKIP_ALL, null, null);
            if (logger.isDebugEnabled()) {
                logger.debug(">>> Reading numberOfMessages page {}, returning {}", (Object)this.pageId, (Object)numberOfMessages);
            }
            int n = numberOfMessages;
            return n;
        }
        finally {
            if (!wasOpen) {
                this.close(false);
            }
        }
    }

    public int getNumberOfMessages() {
        return this.numberOfMessages;
    }

    public long getSize() {
        return this.size;
    }

    private void setSize(long size) {
        this.size = size;
    }

    public String toString() {
        return "Page::seqCreation=" + this.seqInt + ", pageNr=" + this.pageId + ", file=" + this.file;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Page page = (Page)o;
        return this.pageId == page.pageId;
    }

    public int hashCode() {
        return (int)(this.pageId ^ this.pageId >>> 32);
    }

    private void markFileAsSuspect(String fileName, int position, int msgNumber) {
        ActiveMQServerLogger.LOGGER.pageSuspectFile(fileName, position, msgNumber);
        this.suspiciousRecords = true;
    }

    public SequentialFile getFile() {
        return this.file;
    }
}

