/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.cxf.message.Message;

public class MaskSensitiveHelper {
    private static final String ELEMENT_NAME_TEMPLATE = "-ELEMENT_NAME-";
    private static final String PATTERN_XML_NAMESPACE_PREFIX = "[\\w.\\-\\u00B7\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0300-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u203F-\\u2040\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]+";
    private static final String MATCH_PATTERN_XML_TEMPLATE = "(<([\\w.\\-\\u00B7\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0300-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u203F-\\u2040\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]+:)?-ELEMENT_NAME-\\b(?:(?!/>)[^>])*?>)(.*?)(</([\\w.\\-\\u00B7\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0300-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u203F-\\u2040\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]+:)?-ELEMENT_NAME->)";
    private static final String REPLACEMENT_XML_TEMPLATE = "$1XXX$4";
    private static final String MATCH_PATTERN_JSON_TEMPLATE_ARRAY = "\"-ELEMENT_NAME-\"[ \\t]*:[ \\t]*[\\[]((\\s*\".\"),?)+[\\]]";
    private static final String REPLACEMENT_JSON_TEMPLATE_ARRAY = "\"-ELEMENT_NAME-\": [\"X\",\"X\",\"X\"]";
    private static final String MATCH_PATTERN_JSON_TEMPLATE = "\"-ELEMENT_NAME-\"[ \\t]*:[ \\t]*\"(.*?)\"";
    private static final String REPLACEMENT_JSON_TEMPLATE = "\"-ELEMENT_NAME-\": \"XXX\"";
    private static final String MASKED_HEADER_VALUE = "XXX";
    private static final String XML_CONTENT = "xml";
    private static final String HTML_CONTENT = "html";
    private static final String JSON_CONTENT = "json";
    private final Set<ReplacementPair> replacementsXML = new HashSet<ReplacementPair>();
    private final Set<ReplacementPair> replacementsJSON = new HashSet<ReplacementPair>();

    public void setSensitiveElementNames(Set<String> inSensitiveElementNames) {
        this.replacementsXML.clear();
        this.replacementsJSON.clear();
        this.addSensitiveElementNames(inSensitiveElementNames);
    }

    public void addSensitiveElementNames(Set<String> inSensitiveElementNames) {
        for (String sensitiveName : inSensitiveElementNames) {
            this.addReplacementPair(MATCH_PATTERN_XML_TEMPLATE, REPLACEMENT_XML_TEMPLATE, sensitiveName, this.replacementsXML);
            this.addReplacementPair(MATCH_PATTERN_JSON_TEMPLATE_ARRAY, REPLACEMENT_JSON_TEMPLATE_ARRAY, sensitiveName, this.replacementsJSON);
            this.addReplacementPair(MATCH_PATTERN_JSON_TEMPLATE, REPLACEMENT_JSON_TEMPLATE, sensitiveName, this.replacementsJSON);
        }
    }

    private void addReplacementPair(String matchPatternTemplate, String replacementTemplate, String sensitiveName, Set<ReplacementPair> replacements) {
        String matchPatternXML = matchPatternTemplate.replaceAll(ELEMENT_NAME_TEMPLATE, sensitiveName);
        String replacementXML = replacementTemplate.replaceAll(ELEMENT_NAME_TEMPLATE, sensitiveName);
        replacements.add(new ReplacementPair(matchPatternXML, replacementXML));
    }

    public String maskSensitiveElements(Message message, String originalLogString) {
        if (this.replacementsXML.isEmpty() && this.replacementsJSON.isEmpty() || originalLogString == null || message == null) {
            return originalLogString;
        }
        String contentType = (String)message.get((Object)"Content-Type");
        if (contentType == null) {
            return originalLogString;
        }
        String lowerCaseContentType = contentType.toLowerCase();
        if (lowerCaseContentType.contains(XML_CONTENT) || lowerCaseContentType.contains(HTML_CONTENT)) {
            return this.applyMasks(originalLogString, this.replacementsXML);
        }
        if (lowerCaseContentType.contains(JSON_CONTENT)) {
            return this.applyMasks(originalLogString, this.replacementsJSON);
        }
        return originalLogString;
    }

    public void maskHeaders(Map<String, String> headerMap, Set<String> sensitiveHeaderNames) {
        sensitiveHeaderNames.stream().forEach(h -> headerMap.computeIfPresent((String)h, (key, value) -> MASKED_HEADER_VALUE));
    }

    private String applyMasks(String originalLogString, Set<ReplacementPair> replacementPairs) {
        String resultString = originalLogString;
        for (ReplacementPair replacementPair : replacementPairs) {
            resultString = replacementPair.matchPattern.matcher(resultString).replaceAll(replacementPair.replacement);
        }
        return resultString;
    }

    private static class ReplacementPair {
        private final Pattern matchPattern;
        private final String replacement;

        ReplacementPair(String matchPattern, String replacement) {
            this.matchPattern = Pattern.compile(matchPattern, 32);
            this.replacement = replacement;
        }
    }
}

