/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.databinding;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.validation.Schema;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.aegis.databinding.XMLStreamDataReader;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.cxf.aegis.xml.stax.ElementWriter;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Element;

public class ElementDataWriter
implements DataWriter<Element> {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLStreamDataReader.class);
    private AegisDatabinding databinding;
    private Collection<Attachment> attachments;
    private Map<String, Object> properties;

    public ElementDataWriter(AegisDatabinding databinding) {
        this.databinding = databinding;
    }

    public void setAttachments(Collection<Attachment> attachments) {
        this.attachments = attachments;
    }

    public void setSchema(Schema s) {
    }

    public void write(Object obj, MessagePartInfo part, Element output) {
        AegisType type = this.databinding.getType(part);
        if (type == null) {
            throw new Fault(new Message("NO_MESSAGE_FOR_PART", LOG, new Object[0]));
        }
        Context context = new Context(this.databinding.getAegisContext());
        context.setAttachments(this.attachments);
        type = TypeUtil.getWriteType(this.databinding.getAegisContext(), obj, type);
        try {
            W3CDOMStreamWriter domWriter = new W3CDOMStreamWriter(output);
            ElementWriter writer = new ElementWriter((XMLStreamWriter)domWriter);
            MessageWriter w2 = writer.getElementWriter(part.getConcreteName());
            if (type.isNillable() && type.isWriteOuter() && obj == null) {
                w2.writeXsiNil();
                w2.close();
                return;
            }
            type.writeObject(obj, w2, context);
            w2.close();
        }
        catch (DatabindingException e) {
            throw new RuntimeException(e);
        }
    }

    public void write(Object obj, Element output) {
        this.write(obj, null, output);
    }

    public void setProperty(String prop, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(prop, value);
    }

    public Object getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }
}

