/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.TestExecutionResult;

@API(status=API.Status.MAINTAINED, since="1.3")
public class ThrowableCollector {
    private final Predicate<? super Throwable> abortedExecutionPredicate;
    private Throwable throwable;

    public ThrowableCollector(Predicate<? super Throwable> abortedExecutionPredicate) {
        this.abortedExecutionPredicate = Preconditions.notNull(abortedExecutionPredicate, "abortedExecutionPredicate must not be null");
    }

    public void execute(Executable executable) {
        try {
            executable.execute();
        }
        catch (Throwable t) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(t);
            this.add(t);
        }
    }

    private void add(Throwable t) {
        Preconditions.notNull(t, "Throwable must not be null");
        if (this.throwable == null) {
            this.throwable = t;
        } else if (this.hasAbortedExecution(this.throwable) && !this.hasAbortedExecution(t)) {
            t.addSuppressed(this.throwable);
            this.throwable = t;
        } else if (this.throwable != t) {
            this.throwable.addSuppressed(t);
        }
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean isEmpty() {
        return this.throwable == null;
    }

    public boolean isNotEmpty() {
        return this.throwable != null;
    }

    public void assertEmpty() {
        if (!this.isEmpty()) {
            throw ExceptionUtils.throwAsUncheckedException(this.throwable);
        }
    }

    @API(status=API.Status.MAINTAINED, since="1.6")
    public TestExecutionResult toTestExecutionResult() {
        if (this.isEmpty()) {
            return TestExecutionResult.successful();
        }
        if (this.hasAbortedExecution(this.throwable)) {
            return TestExecutionResult.aborted(this.throwable);
        }
        return TestExecutionResult.failed(this.throwable);
    }

    private boolean hasAbortedExecution(Throwable t) {
        return this.abortedExecutionPredicate.test(t);
    }

    @FunctionalInterface
    public static interface Executable {
        public void execute() throws Throwable;
    }

    public static interface Factory {
        public ThrowableCollector create();
    }
}

