/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.document;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.rat.api.Document;
import org.apache.rat.config.exclusion.ExclusionUtils;
import org.apache.rat.document.DocumentName;
import org.apache.rat.document.DocumentNameMatcher;
import org.apache.rat.document.IgnoredDocument;

public class FileDocument
extends Document {
    private final File file;

    public FileDocument(DocumentName basedir, File file, DocumentNameMatcher nameMatcher) {
        super(DocumentName.builder(file).setBaseName(basedir.getBaseName()).build(), nameMatcher);
        this.file = file;
    }

    public FileDocument(File file, DocumentNameMatcher nameMatcher) {
        super(DocumentName.builder(file).setBaseName(File.separator).build(), nameMatcher);
        this.file = file;
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public SortedSet<Document> listChildren() {
        if (this.isDirectory()) {
            TreeSet<Document> result = new TreeSet<Document>();
            File[] files = this.file.listFiles();
            if (files != null) {
                FileFilter fileFilter = ExclusionUtils.asFileFilter(this.name, this.nameMatcher);
                for (File child : files) {
                    Document childDoc = fileFilter.accept(child) ? new FileDocument(this.name, child, this.nameMatcher) : new IgnoredDocument(this.name, child, this.nameMatcher);
                    result.add(childDoc);
                }
            }
            return result;
        }
        return Collections.emptySortedSet();
    }

    @Override
    public InputStream inputStream() throws IOException {
        return Files.newInputStream(this.file.toPath(), new OpenOption[0]);
    }

    public File getFile() {
        return this.file;
    }
}

