/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import java.math.BigInteger;
import org.apache.commons.statistics.descriptive.IntStatistic;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;
import org.apache.commons.statistics.descriptive.Statistics;

public final class IntMin
implements IntStatistic,
StatisticAccumulator<IntMin> {
    private int minimum = Integer.MAX_VALUE;

    private IntMin() {
    }

    public static IntMin create() {
        return new IntMin();
    }

    public static IntMin of(int ... values) {
        return Statistics.add(new IntMin(), values);
    }

    public static IntMin ofRange(int[] values, int from, int to) {
        Statistics.checkFromToIndex(from, to, values.length);
        return IntMin.createFromRange(values, from, to);
    }

    static IntMin createFromRange(int[] values, int from, int to) {
        return Statistics.add(new IntMin(), values, from, to);
    }

    @Override
    public void accept(int value) {
        this.minimum = Math.min(this.minimum, value);
    }

    @Override
    public int getAsInt() {
        return this.minimum;
    }

    @Override
    public long getAsLong() {
        return this.minimum;
    }

    @Override
    public double getAsDouble() {
        return this.minimum;
    }

    @Override
    public BigInteger getAsBigInteger() {
        return BigInteger.valueOf(this.minimum);
    }

    @Override
    public IntMin combine(IntMin other) {
        this.accept(other.getAsInt());
        return this;
    }
}

