/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.analysis.solvers;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math4.legacy.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math4.legacy.analysis.solvers.AbstractUnivariateDifferentiableSolver;
import org.apache.commons.math4.legacy.analysis.solvers.UnivariateSolverUtils;
import org.apache.commons.math4.legacy.exception.TooManyEvaluationsException;

public class NewtonRaphsonSolver
extends AbstractUnivariateDifferentiableSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public NewtonRaphsonSolver() {
        this(1.0E-6);
    }

    public NewtonRaphsonSolver(double absoluteAccuracy) {
        super(absoluteAccuracy);
    }

    @Override
    public double solve(int maxEval, UnivariateDifferentiableFunction f, double min, double max) throws TooManyEvaluationsException {
        return super.solve(maxEval, f, UnivariateSolverUtils.midpoint(min, max));
    }

    @Override
    protected double doSolve() throws TooManyEvaluationsException {
        double startValue = this.getStartValue();
        double absoluteAccuracy = this.getAbsoluteAccuracy();
        double x0 = startValue;
        while (true) {
            DerivativeStructure y0 = this.computeObjectiveValueAndDerivative(x0);
            int[] nArray = new int[]{1};
            double x1 = x0 - y0.getValue() / y0.getPartialDerivative(nArray);
            if (JdkMath.abs((double)(x1 - x0)) <= absoluteAccuracy) {
                return x1;
            }
            x0 = x1;
        }
    }
}

