/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.ode.FieldExpandableODE;
import org.apache.commons.math3.ode.FieldODEState;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.FirstOrderFieldDifferentialEquations;
import org.apache.commons.math3.ode.TestFieldProblem1;
import org.apache.commons.math3.ode.TestFieldProblem3;
import org.apache.commons.math3.ode.TestFieldProblem4;
import org.apache.commons.math3.ode.TestFieldProblem5;
import org.apache.commons.math3.ode.TestFieldProblemHandler;
import org.apache.commons.math3.ode.events.Action;
import org.apache.commons.math3.ode.events.FieldEventHandler;
import org.apache.commons.math3.ode.nonstiff.DormandPrince853FieldIntegrator;
import org.apache.commons.math3.ode.nonstiff.EmbeddedRungeKuttaFieldIntegrator;
import org.apache.commons.math3.ode.sampling.FieldStepHandler;
import org.apache.commons.math3.ode.sampling.FieldStepInterpolator;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EmbeddedRungeKuttaFieldIntegratorAbstractTest {
    protected abstract <T extends RealFieldElement<T>> EmbeddedRungeKuttaFieldIntegrator<T> createIntegrator(Field<T> var1, double var2, double var4, double var6, double var8);

    protected abstract <T extends RealFieldElement<T>> EmbeddedRungeKuttaFieldIntegrator<T> createIntegrator(Field<T> var1, double var2, double var4, double[] var6, double[] var7);

    @Test
    public abstract void testNonFieldIntegratorConsistency();

    protected <T extends RealFieldElement<T>> void doTestNonFieldIntegratorConsistency(Field<T> field) {
        try {
            EmbeddedRungeKuttaFieldIntegrator<T> fieldIntegrator = this.createIntegrator(field, 0.001, 1.0, 1.0, 1.0);
            RealFieldElement[][] fieldA = fieldIntegrator.getA();
            RealFieldElement[] fieldB = fieldIntegrator.getB();
            RealFieldElement[] fieldC = fieldIntegrator.getC();
            if (fieldIntegrator instanceof DormandPrince853FieldIntegrator) {
                RealFieldElement[][] reducedFieldA = (RealFieldElement[][])MathArrays.buildArray(field, (int)12, (int)-1);
                RealFieldElement[] reducedFieldB = (RealFieldElement[])MathArrays.buildArray(field, (int)13);
                RealFieldElement[] reducedFieldC = (RealFieldElement[])MathArrays.buildArray(field, (int)12);
                System.arraycopy(fieldA, 0, reducedFieldA, 0, reducedFieldA.length);
                System.arraycopy(fieldB, 0, reducedFieldB, 0, reducedFieldB.length);
                System.arraycopy(fieldC, 0, reducedFieldC, 0, reducedFieldC.length);
                fieldA = reducedFieldA;
                fieldB = reducedFieldB;
                fieldC = reducedFieldC;
            }
            String fieldName = fieldIntegrator.getClass().getName();
            String regularName = fieldName.replaceAll("Field", "");
            Class<?> c = Class.forName(regularName);
            java.lang.reflect.Field jlrFieldA = c.getDeclaredField("STATIC_A");
            jlrFieldA.setAccessible(true);
            double[][] regularA = (double[][])jlrFieldA.get(null);
            java.lang.reflect.Field jlrFieldB = c.getDeclaredField("STATIC_B");
            jlrFieldB.setAccessible(true);
            double[] regularB = (double[])jlrFieldB.get(null);
            java.lang.reflect.Field jlrFieldC = c.getDeclaredField("STATIC_C");
            jlrFieldC.setAccessible(true);
            double[] regularC = (double[])jlrFieldC.get(null);
            Assert.assertEquals((long)regularA.length, (long)fieldA.length);
            for (int i = 0; i < regularA.length; ++i) {
                this.checkArray(regularA[i], fieldA[i]);
            }
            this.checkArray(regularB, fieldB);
            this.checkArray(regularC, fieldC);
        }
        catch (ClassNotFoundException cnfe) {
            Assert.fail((String)cnfe.getLocalizedMessage());
        }
        catch (IllegalAccessException iae) {
            Assert.fail((String)iae.getLocalizedMessage());
        }
        catch (IllegalArgumentException iae) {
            Assert.fail((String)iae.getLocalizedMessage());
        }
        catch (SecurityException se) {
            Assert.fail((String)se.getLocalizedMessage());
        }
        catch (NoSuchFieldException nsfe) {
            Assert.fail((String)nsfe.getLocalizedMessage());
        }
    }

    private <T extends RealFieldElement<T>> void checkArray(double[] regularArray, T[] fieldArray) {
        Assert.assertEquals((long)regularArray.length, (long)fieldArray.length);
        for (int i = 0; i < regularArray.length; ++i) {
            if (regularArray[i] == 0.0) {
                Assert.assertTrue((0.0 == fieldArray[i].getReal() ? 1 : 0) != 0);
                continue;
            }
            Assert.assertEquals((double)regularArray[i], (double)fieldArray[i].getReal(), (double)FastMath.ulp((double)regularArray[i]));
        }
    }

    @Test
    public abstract void testForwardBackwardExceptions();

    protected <T extends RealFieldElement<T>> void doTestForwardBackwardExceptions(Field<T> field) {
        FirstOrderFieldDifferentialEquations equations = new FirstOrderFieldDifferentialEquations<T>(){

            public int getDimension() {
                return 1;
            }

            public void init(T t0, T[] y0, T t) {
            }

            public T[] computeDerivatives(T t, T[] y) {
                if (t.getReal() < -0.5) {
                    throw new LocalException();
                }
                throw new RuntimeException("oops");
            }
        };
        EmbeddedRungeKuttaFieldIntegrator<T> integrator = this.createIntegrator(field, 0.0, 1.0, 1.0E-10, 1.0E-10);
        try {
            integrator.integrate(new FieldExpandableODE(equations), new FieldODEState((RealFieldElement)((RealFieldElement)field.getOne()).negate(), (RealFieldElement[])MathArrays.buildArray(field, (int)1)), (RealFieldElement)field.getZero());
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (LocalException localException) {
            // empty catch block
        }
        try {
            integrator.integrate(new FieldExpandableODE(equations), new FieldODEState((RealFieldElement)field.getZero(), (RealFieldElement[])MathArrays.buildArray(field, (int)1)), (RealFieldElement)field.getOne());
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test(expected=NumberIsTooSmallException.class)
    public abstract void testMinStep();

    protected <T extends RealFieldElement<T>> void doTestMinStep(Field<T> field) throws NumberIsTooSmallException {
        TestFieldProblem1<T> pb = new TestFieldProblem1<T>(field);
        double minStep = ((RealFieldElement)((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).multiply(0.1)).getReal();
        double maxStep = ((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).getReal();
        double[] vecAbsoluteTolerance = new double[]{1.0E-15, 1.0E-16};
        double[] vecRelativeTolerance = new double[]{1.0E-15, 1.0E-16};
        EmbeddedRungeKuttaFieldIntegrator<T> integ = this.createIntegrator(field, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        TestFieldProblemHandler<T> handler = new TestFieldProblemHandler<T>(pb, integ);
        integ.addStepHandler(handler);
        integ.integrate(new FieldExpandableODE(pb), pb.getInitialState(), pb.getFinalTime());
        Assert.fail((String)"an exception should have been thrown");
    }

    @Test
    public abstract void testIncreasingTolerance();

    protected <T extends RealFieldElement<T>> void doTestIncreasingTolerance(Field<T> field, double factor, double epsilon) {
        int previousCalls = Integer.MAX_VALUE;
        for (int i = -12; i < -2; ++i) {
            TestFieldProblem1<T> pb = new TestFieldProblem1<T>(field);
            double minStep = 0.0;
            double maxStep = ((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).getReal();
            double scalAbsoluteTolerance = FastMath.pow((double)10.0, (int)i);
            double scalRelativeTolerance = 0.01 * scalAbsoluteTolerance;
            EmbeddedRungeKuttaFieldIntegrator<T> integ = this.createIntegrator(field, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
            TestFieldProblemHandler<T> handler = new TestFieldProblemHandler<T>(pb, integ);
            integ.addStepHandler(handler);
            integ.integrate(new FieldExpandableODE(pb), pb.getInitialState(), pb.getFinalTime());
            Assert.assertTrue((handler.getMaximalValueError().getReal() < factor * scalAbsoluteTolerance ? 1 : 0) != 0);
            Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError().getReal(), (double)epsilon);
            int calls = pb.getCalls();
            Assert.assertEquals((long)integ.getEvaluations(), (long)calls);
            Assert.assertTrue((calls <= previousCalls ? 1 : 0) != 0);
            previousCalls = calls;
        }
    }

    @Test
    public abstract void testEvents();

    protected <T extends RealFieldElement<T>> void doTestEvents(Field<T> field, double epsilonMaxValue, String name) {
        TestFieldProblem4<T> pb = new TestFieldProblem4<T>(field);
        double minStep = 0.0;
        double maxStep = ((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).getReal();
        double scalAbsoluteTolerance = 1.0E-8;
        double scalRelativeTolerance = 0.01 * scalAbsoluteTolerance;
        EmbeddedRungeKuttaFieldIntegrator<T> integ = this.createIntegrator(field, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        TestFieldProblemHandler<T> handler = new TestFieldProblemHandler<T>(pb, integ);
        integ.addStepHandler(handler);
        FieldEventHandler<T>[] functions = pb.getEventsHandlers();
        double convergence = 1.0E-8 * maxStep;
        for (int l = 0; l < functions.length; ++l) {
            integ.addEventHandler(functions[l], Double.POSITIVE_INFINITY, convergence, 1000);
        }
        Assert.assertEquals((long)functions.length, (long)integ.getEventHandlers().size());
        integ.integrate(new FieldExpandableODE(pb), pb.getInitialState(), pb.getFinalTime());
        Assert.assertEquals((double)0.0, (double)handler.getMaximalValueError().getReal(), (double)epsilonMaxValue);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError().getReal(), (double)convergence);
        Assert.assertEquals((double)12.0, (double)handler.getLastTime().getReal(), (double)convergence);
        Assert.assertEquals((Object)name, (Object)integ.getName());
        integ.clearEventHandlers();
        Assert.assertEquals((long)0L, (long)integ.getEventHandlers().size());
    }

    @Test(expected=LocalException.class)
    public abstract void testEventsErrors();

    protected <T extends RealFieldElement<T>> void doTestEventsErrors(Field<T> field) throws LocalException {
        final TestFieldProblem1<T> pb = new TestFieldProblem1<T>(field);
        double minStep = 0.0;
        double maxStep = ((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).getReal();
        double scalAbsoluteTolerance = 1.0E-8;
        double scalRelativeTolerance = 0.01 * scalAbsoluteTolerance;
        EmbeddedRungeKuttaFieldIntegrator<T> integ = this.createIntegrator(field, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        TestFieldProblemHandler<T> handler = new TestFieldProblemHandler<T>(pb, integ);
        integ.addStepHandler(handler);
        integ.addEventHandler(new FieldEventHandler<T>(){

            public void init(FieldODEStateAndDerivative<T> state0, T t) {
            }

            public Action eventOccurred(FieldODEStateAndDerivative<T> state, boolean increasing) {
                return Action.CONTINUE;
            }

            public T g(FieldODEStateAndDerivative<T> state) {
                RealFieldElement middle = (RealFieldElement)((RealFieldElement)pb.getInitialState().getTime().add(pb.getFinalTime())).multiply(0.5);
                RealFieldElement offset = (RealFieldElement)state.getTime().subtract((Object)middle);
                if (offset.getReal() > 0.0) {
                    throw new LocalException();
                }
                return offset;
            }

            public FieldODEState<T> resetState(FieldODEStateAndDerivative<T> state) {
                return state;
            }
        }, Double.POSITIVE_INFINITY, 1.0E-8 * maxStep, 1000);
        integ.integrate(new FieldExpandableODE(pb), pb.getInitialState(), pb.getFinalTime());
    }

    @Test
    public abstract void testEventsNoConvergence();

    protected <T extends RealFieldElement<T>> void doTestEventsNoConvergence(Field<T> field) {
        final TestFieldProblem1<T> pb = new TestFieldProblem1<T>(field);
        double minStep = 0.0;
        double maxStep = ((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).getReal();
        double scalAbsoluteTolerance = 1.0E-8;
        double scalRelativeTolerance = 0.01 * scalAbsoluteTolerance;
        EmbeddedRungeKuttaFieldIntegrator<T> integ = this.createIntegrator(field, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        TestFieldProblemHandler<T> handler = new TestFieldProblemHandler<T>(pb, integ);
        integ.addStepHandler(handler);
        integ.addEventHandler(new FieldEventHandler<T>(){

            public void init(FieldODEStateAndDerivative<T> state0, T t) {
            }

            public Action eventOccurred(FieldODEStateAndDerivative<T> state, boolean increasing) {
                return Action.CONTINUE;
            }

            public T g(FieldODEStateAndDerivative<T> state) {
                RealFieldElement middle = (RealFieldElement)((RealFieldElement)pb.getInitialState().getTime().add(pb.getFinalTime())).multiply(0.5);
                RealFieldElement offset = (RealFieldElement)state.getTime().subtract((Object)middle);
                return offset.getReal() > 0.0 ? (RealFieldElement)offset.add(0.5) : (RealFieldElement)offset.subtract(0.5);
            }

            public FieldODEState<T> resetState(FieldODEStateAndDerivative<T> state) {
                return state;
            }
        }, Double.POSITIVE_INFINITY, 1.0E-8 * maxStep, 3);
        try {
            integ.integrate(new FieldExpandableODE(pb), pb.getInitialState(), pb.getFinalTime());
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MaxCountExceededException maxCountExceededException) {
            // empty catch block
        }
    }

    @Test
    public abstract void testSanityChecks();

    protected <T extends RealFieldElement<T>> void doTestSanityChecks(Field<T> field) {
        EmbeddedRungeKuttaFieldIntegrator<T> integrator2;
        TestFieldProblem3<T> pb = new TestFieldProblem3<T>(field);
        try {
            integrator2 = this.createIntegrator(field, 0.0, ((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).getReal(), new double[4], new double[4]);
            integrator2.integrate(new FieldExpandableODE(pb), new FieldODEState(pb.getInitialState().getTime(), (RealFieldElement[])MathArrays.buildArray(field, (int)6)), pb.getFinalTime());
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException integrator2) {
            // empty catch block
        }
        try {
            integrator2 = this.createIntegrator(field, 0.0, ((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).getReal(), new double[2], new double[4]);
            integrator2.integrate(new FieldExpandableODE(pb), pb.getInitialState(), pb.getFinalTime());
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException integrator3) {
            // empty catch block
        }
        try {
            integrator2 = this.createIntegrator(field, 0.0, ((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).getReal(), new double[4], new double[4]);
            integrator2.integrate(new FieldExpandableODE(pb), pb.getInitialState(), pb.getInitialState().getTime());
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
    }

    @Test
    public abstract void testBackward();

    protected <T extends RealFieldElement<T>> void doTestBackward(Field<T> field, double epsilonLast, double epsilonMaxValue, double epsilonMaxTime, String name) throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestFieldProblem5<T> pb = new TestFieldProblem5<T>(field);
        double minStep = 0.0;
        double maxStep = ((RealFieldElement)((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).abs()).getReal();
        double scalAbsoluteTolerance = 1.0E-8;
        double scalRelativeTolerance = 0.01 * scalAbsoluteTolerance;
        EmbeddedRungeKuttaFieldIntegrator<T> integ = this.createIntegrator(field, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        TestFieldProblemHandler<T> handler = new TestFieldProblemHandler<T>(pb, integ);
        integ.addStepHandler(handler);
        integ.integrate(new FieldExpandableODE(pb), pb.getInitialState(), pb.getFinalTime());
        Assert.assertEquals((double)0.0, (double)handler.getLastError().getReal(), (double)epsilonLast);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalValueError().getReal(), (double)epsilonMaxValue);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError().getReal(), (double)epsilonMaxTime);
        Assert.assertEquals((Object)name, (Object)integ.getName());
    }

    @Test
    public abstract void testKepler();

    protected <T extends RealFieldElement<T>> void doTestKepler(Field<T> field, double epsilon) {
        TestFieldProblem3<RealFieldElement> pb = new TestFieldProblem3<RealFieldElement>(field, (RealFieldElement)((RealFieldElement)field.getZero()).add(0.9));
        double minStep = 0.0;
        double maxStep = ((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).getReal();
        double[] vecAbsoluteTolerance = new double[]{1.0E-8, 1.0E-8, 1.0E-10, 1.0E-10};
        double[] vecRelativeTolerance = new double[]{1.0E-10, 1.0E-10, 1.0E-8, 1.0E-8};
        EmbeddedRungeKuttaFieldIntegrator<T> integ = this.createIntegrator(field, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        integ.addStepHandler(new KeplerHandler<RealFieldElement>(pb, epsilon));
        integ.integrate(new FieldExpandableODE(pb), pb.getInitialState(), pb.getFinalTime());
    }

    @Test
    public abstract void testPartialDerivatives();

    protected void doTestPartialDerivatives(double epsilonY, double[] epsilonPartials) {
        int parameters = 5;
        boolean order = true;
        boolean parOmega = false;
        boolean parTO = true;
        int parY00 = 2;
        int parY01 = 3;
        int parT = 4;
        DerivativeStructure omega = new DerivativeStructure(5, 1, 0, 1.3);
        DerivativeStructure t0 = new DerivativeStructure(5, 1, 1, 1.3);
        DerivativeStructure[] y0 = new DerivativeStructure[]{new DerivativeStructure(5, 1, 2, 3.0), new DerivativeStructure(5, 1, 3, 4.0)};
        DerivativeStructure t = new DerivativeStructure(5, 1, 4, 6.0);
        SinCos sinCos = new SinCos(omega);
        EmbeddedRungeKuttaFieldIntegrator integrator = this.createIntegrator(omega.getField(), t.subtract(t0).multiply(0.001).getReal(), t.subtract(t0).getReal(), 1.0E-12, 1.0E-12);
        FieldODEStateAndDerivative result = integrator.integrate(new FieldExpandableODE((FirstOrderFieldDifferentialEquations)sinCos), new FieldODEState((RealFieldElement)t0, (RealFieldElement[])y0), (RealFieldElement)t);
        for (int i = 0; i < sinCos.getDimension(); ++i) {
            Assert.assertEquals((double)sinCos.theoreticalY(t.getReal())[i], (double)((DerivativeStructure[])result.getState())[i].getValue(), (double)epsilonY);
        }
        double[][] derivatives = sinCos.getDerivatives(t.getReal());
        for (int i = 0; i < sinCos.getDimension(); ++i) {
            for (int parameter = 0; parameter < 5; ++parameter) {
                Assert.assertEquals((double)derivatives[i][parameter], (double)this.dYdP(((DerivativeStructure[])result.getState())[i], parameter), (double)epsilonPartials[parameter]);
            }
        }
    }

    private double dYdP(DerivativeStructure y, int parameter) {
        int[] orders = new int[y.getFreeParameters()];
        orders[parameter] = 1;
        return y.getPartialDerivative(orders);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SinCos
    implements FirstOrderFieldDifferentialEquations<DerivativeStructure> {
        private final DerivativeStructure omega;
        private DerivativeStructure r;
        private DerivativeStructure alpha;
        private double dRdY00;
        private double dRdY01;
        private double dAlphadOmega;
        private double dAlphadT0;
        private double dAlphadY00;
        private double dAlphadY01;

        protected SinCos(DerivativeStructure omega) {
            this.omega = omega;
        }

        public int getDimension() {
            return 2;
        }

        public void init(DerivativeStructure t0, DerivativeStructure[] y0, DerivativeStructure finalTime) {
            DerivativeStructure r2 = y0[0].multiply(y0[0]).add(y0[1].multiply(y0[1]));
            this.r = r2.sqrt();
            this.dRdY00 = y0[0].divide(this.r).getReal();
            this.dRdY01 = y0[1].divide(this.r).getReal();
            this.alpha = y0[0].atan2(y0[1]).subtract(t0.multiply(this.omega));
            this.dAlphadOmega = -t0.getReal();
            this.dAlphadT0 = -this.omega.getReal();
            this.dAlphadY00 = y0[1].divide(r2).getReal();
            this.dAlphadY01 = y0[0].negate().divide(r2).getReal();
        }

        public DerivativeStructure[] computeDerivatives(DerivativeStructure t, DerivativeStructure[] y) {
            return new DerivativeStructure[]{this.omega.multiply(y[1]), this.omega.multiply(y[0]).negate()};
        }

        public double[] theoreticalY(double t) {
            double theta = this.omega.getReal() * t + this.alpha.getReal();
            return new double[]{this.r.getReal() * FastMath.sin((double)theta), this.r.getReal() * FastMath.cos((double)theta)};
        }

        public double[][] getDerivatives(double t) {
            double theta = this.omega.getReal() * t + this.alpha.getReal();
            double sin = FastMath.sin((double)theta);
            double cos = FastMath.cos((double)theta);
            double y0 = this.r.getReal() * sin;
            double y1 = this.r.getReal() * cos;
            double dY0dOmega = y1 * (t + this.dAlphadOmega);
            double dY0dT0 = y1 * this.dAlphadT0;
            double dY0dY00 = this.dRdY00 * sin + y1 * this.dAlphadY00;
            double dY0dY01 = this.dRdY01 * sin + y1 * this.dAlphadY01;
            double dY0dT = y1 * this.omega.getReal();
            double dY1dOmega = -y0 * (t + this.dAlphadOmega);
            double dY1dT0 = -y0 * this.dAlphadT0;
            double dY1dY00 = this.dRdY00 * cos - y0 * this.dAlphadY00;
            double dY1dY01 = this.dRdY01 * cos - y0 * this.dAlphadY01;
            double dY1dT = -y0 * this.omega.getReal();
            return new double[][]{{dY0dOmega, dY0dT0, dY0dY00, dY0dY01, dY0dT}, {dY1dOmega, dY1dT0, dY1dY00, dY1dY01, dY1dT}};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeplerHandler<T extends RealFieldElement<T>>
    implements FieldStepHandler<T> {
        private T maxError;
        private final TestFieldProblem3<T> pb;
        private final double epsilon;

        public KeplerHandler(TestFieldProblem3<T> pb, double epsilon) {
            this.pb = pb;
            this.epsilon = epsilon;
            this.maxError = (RealFieldElement)pb.getField().getZero();
        }

        public void init(FieldODEStateAndDerivative<T> state0, T t) {
            this.maxError = (RealFieldElement)this.pb.getField().getZero();
        }

        public void handleStep(FieldStepInterpolator<T> interpolator, boolean isLast) throws MaxCountExceededException {
            FieldODEStateAndDerivative current = interpolator.getCurrentState();
            RealFieldElement[] theoreticalY = this.pb.computeTheoreticalState(current.getTime());
            RealFieldElement dx = (RealFieldElement)current.getState()[0].subtract((Object)theoreticalY[0]);
            RealFieldElement dy = (RealFieldElement)current.getState()[1].subtract((Object)theoreticalY[1]);
            RealFieldElement error = (RealFieldElement)((RealFieldElement)dx.multiply((Object)dx)).add(dy.multiply((Object)dy));
            if (((RealFieldElement)error.subtract(this.maxError)).getReal() > 0.0) {
                this.maxError = error;
            }
            if (isLast) {
                Assert.assertEquals((double)0.0, (double)this.maxError.getReal(), (double)this.epsilon);
            }
        }
    }

    protected static class LocalException
    extends RuntimeException {
        private static final long serialVersionUID = 20151208L;

        protected LocalException() {
        }
    }
}

