/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.fraction;

import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.fraction.Fraction;
import org.apache.commons.math3.fraction.FractionConversionException;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class FractionTest {
    private void assertFraction(int expectedNumerator, int expectedDenominator, Fraction actual) {
        Assert.assertEquals((long)expectedNumerator, (long)actual.getNumerator());
        Assert.assertEquals((long)expectedDenominator, (long)actual.getDenominator());
    }

    @Test
    public void testConstructor() {
        this.assertFraction(0, 1, new Fraction(0, 1));
        this.assertFraction(0, 1, new Fraction(0, 2));
        this.assertFraction(0, 1, new Fraction(0, -1));
        this.assertFraction(1, 2, new Fraction(1, 2));
        this.assertFraction(1, 2, new Fraction(2, 4));
        this.assertFraction(-1, 2, new Fraction(-1, 2));
        this.assertFraction(-1, 2, new Fraction(1, -2));
        this.assertFraction(-1, 2, new Fraction(-2, 4));
        this.assertFraction(-1, 2, new Fraction(2, -4));
        try {
            new Fraction(Integer.MIN_VALUE, -1);
            Assert.fail();
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        try {
            new Fraction(1, Integer.MIN_VALUE);
            Assert.fail();
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        this.assertFraction(0, 1, new Fraction(1.0E-14));
        this.assertFraction(2, 5, new Fraction(0.40000000000001));
        this.assertFraction(15, 1, new Fraction(15.0000000000001));
    }

    @Test(expected=ConvergenceException.class)
    public void testGoldenRatio() {
        new Fraction((1.0 + FastMath.sqrt((double)5.0)) / 2.0, 1.0E-12, 25);
    }

    @Test
    public void testDoubleConstructor() throws ConvergenceException {
        this.assertFraction(1, 2, new Fraction(0.5));
        this.assertFraction(1, 3, new Fraction(0.3333333333333333));
        this.assertFraction(2, 3, new Fraction(0.6666666666666666));
        this.assertFraction(1, 4, new Fraction(0.25));
        this.assertFraction(3, 4, new Fraction(0.75));
        this.assertFraction(1, 5, new Fraction(0.2));
        this.assertFraction(2, 5, new Fraction(0.4));
        this.assertFraction(3, 5, new Fraction(0.6));
        this.assertFraction(4, 5, new Fraction(0.8));
        this.assertFraction(1, 6, new Fraction(0.16666666666666666));
        this.assertFraction(5, 6, new Fraction(0.8333333333333334));
        this.assertFraction(1, 7, new Fraction(0.14285714285714285));
        this.assertFraction(2, 7, new Fraction(0.2857142857142857));
        this.assertFraction(3, 7, new Fraction(0.42857142857142855));
        this.assertFraction(4, 7, new Fraction(0.5714285714285714));
        this.assertFraction(5, 7, new Fraction(0.7142857142857143));
        this.assertFraction(6, 7, new Fraction(0.8571428571428571));
        this.assertFraction(1, 8, new Fraction(0.125));
        this.assertFraction(3, 8, new Fraction(0.375));
        this.assertFraction(5, 8, new Fraction(0.625));
        this.assertFraction(7, 8, new Fraction(0.875));
        this.assertFraction(1, 9, new Fraction(0.1111111111111111));
        this.assertFraction(2, 9, new Fraction(0.2222222222222222));
        this.assertFraction(4, 9, new Fraction(0.4444444444444444));
        this.assertFraction(5, 9, new Fraction(0.5555555555555556));
        this.assertFraction(7, 9, new Fraction(0.7777777777777778));
        this.assertFraction(8, 9, new Fraction(0.8888888888888888));
        this.assertFraction(1, 10, new Fraction(0.1));
        this.assertFraction(3, 10, new Fraction(0.3));
        this.assertFraction(7, 10, new Fraction(0.7));
        this.assertFraction(9, 10, new Fraction(0.9));
        this.assertFraction(1, 11, new Fraction(0.09090909090909091));
        this.assertFraction(2, 11, new Fraction(0.18181818181818182));
        this.assertFraction(3, 11, new Fraction(0.2727272727272727));
        this.assertFraction(4, 11, new Fraction(0.36363636363636365));
        this.assertFraction(5, 11, new Fraction(0.45454545454545453));
        this.assertFraction(6, 11, new Fraction(0.5454545454545454));
        this.assertFraction(7, 11, new Fraction(0.6363636363636364));
        this.assertFraction(8, 11, new Fraction(0.7272727272727273));
        this.assertFraction(9, 11, new Fraction(0.8181818181818182));
        this.assertFraction(10, 11, new Fraction(0.9090909090909091));
    }

    @Test
    public void testDigitLimitConstructor() throws ConvergenceException {
        this.assertFraction(2, 5, new Fraction(0.4, 9));
        this.assertFraction(2, 5, new Fraction(0.4, 99));
        this.assertFraction(2, 5, new Fraction(0.4, 999));
        this.assertFraction(3, 5, new Fraction(0.6152, 9));
        this.assertFraction(8, 13, new Fraction(0.6152, 99));
        this.assertFraction(510, 829, new Fraction(0.6152, 999));
        this.assertFraction(769, 1250, new Fraction(0.6152, 9999));
        this.assertFraction(1, 2, new Fraction(0.5000000001, 10));
    }

    @Test
    public void testIntegerOverflow() {
        this.checkIntegerOverflow(0.7500000000145519);
        this.checkIntegerOverflow(1.0E10);
        this.checkIntegerOverflow(-1.0E10);
        this.checkIntegerOverflow(-43979.60679604749);
    }

    private void checkIntegerOverflow(double a) {
        try {
            Fraction f = new Fraction(a, 1.0E-12, 1000);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (ConvergenceException convergenceException) {
            // empty catch block
        }
    }

    @Test
    public void testEpsilonLimitConstructor() throws ConvergenceException {
        this.assertFraction(2, 5, new Fraction(0.4, 1.0E-5, 100));
        this.assertFraction(3, 5, new Fraction(0.6152, 0.02, 100));
        this.assertFraction(8, 13, new Fraction(0.6152, 0.001, 100));
        this.assertFraction(251, 408, new Fraction(0.6152, 1.0E-4, 100));
        this.assertFraction(251, 408, new Fraction(0.6152, 1.0E-5, 100));
        this.assertFraction(510, 829, new Fraction(0.6152, 1.0E-6, 100));
        this.assertFraction(769, 1250, new Fraction(0.6152, 1.0E-7, 100));
    }

    @Test
    public void testCompareTo() {
        Fraction first = new Fraction(1, 2);
        Fraction second = new Fraction(1, 3);
        Fraction third = new Fraction(1, 2);
        Assert.assertEquals((long)0L, (long)first.compareTo(first));
        Assert.assertEquals((long)0L, (long)first.compareTo(third));
        Assert.assertEquals((long)1L, (long)first.compareTo(second));
        Assert.assertEquals((long)-1L, (long)second.compareTo(first));
        Fraction pi1 = new Fraction(1068966896, 340262731);
        Fraction pi2 = new Fraction(411557987, 131002976);
        Assert.assertEquals((long)-1L, (long)pi1.compareTo(pi2));
        Assert.assertEquals((long)1L, (long)pi2.compareTo(pi1));
        Assert.assertEquals((double)0.0, (double)(pi1.doubleValue() - pi2.doubleValue()), (double)1.0E-20);
    }

    @Test
    public void testDoubleValue() {
        Fraction first = new Fraction(1, 2);
        Fraction second = new Fraction(1, 3);
        Assert.assertEquals((double)0.5, (double)first.doubleValue(), (double)0.0);
        Assert.assertEquals((double)0.3333333333333333, (double)second.doubleValue(), (double)0.0);
    }

    @Test
    public void testFloatValue() {
        Fraction first = new Fraction(1, 2);
        Fraction second = new Fraction(1, 3);
        Assert.assertEquals((float)0.5f, (float)first.floatValue(), (float)0.0f);
        Assert.assertEquals((float)0.33333334f, (float)second.floatValue(), (float)0.0f);
    }

    @Test
    public void testIntValue() {
        Fraction first = new Fraction(1, 2);
        Fraction second = new Fraction(3, 2);
        Assert.assertEquals((long)0L, (long)first.intValue());
        Assert.assertEquals((long)1L, (long)second.intValue());
    }

    @Test
    public void testLongValue() {
        Fraction first = new Fraction(1, 2);
        Fraction second = new Fraction(3, 2);
        Assert.assertEquals((long)0L, (long)first.longValue());
        Assert.assertEquals((long)1L, (long)second.longValue());
    }

    @Test
    public void testConstructorDouble() {
        this.assertFraction(1, 2, new Fraction(0.5));
        this.assertFraction(1, 3, new Fraction(0.3333333333333333));
        this.assertFraction(17, 100, new Fraction(0.17));
        this.assertFraction(317, 100, new Fraction(3.17));
        this.assertFraction(-1, 2, new Fraction(-0.5));
        this.assertFraction(-1, 3, new Fraction(-0.3333333333333333));
        this.assertFraction(-17, 100, new Fraction(-0.17));
        this.assertFraction(-317, 100, new Fraction(-3.17));
    }

    @Test
    public void testAbs() {
        Fraction a = new Fraction(10, 21);
        Fraction b = new Fraction(-10, 21);
        Fraction c = new Fraction(10, -21);
        this.assertFraction(10, 21, a.abs());
        this.assertFraction(10, 21, b.abs());
        this.assertFraction(10, 21, c.abs());
    }

    @Test
    public void testPercentage() {
        Assert.assertEquals((double)50.0, (double)new Fraction(1, 2).percentageValue(), (double)1.0E-15);
    }

    @Test
    public void testMath835() {
        int numer = 21691754;
        boolean denom = true;
        double percentage = 2.1691754E9;
        Fraction frac = new Fraction(21691754, 1);
        Assert.assertEquals((double)2.1691754E9, (double)frac.percentageValue(), (double)Math.ulp(2.1691754E9));
    }

    @Test
    public void testMath1261() {
        Fraction a = new Fraction(Integer.MAX_VALUE, 2);
        Fraction b = a.multiply(2);
        Assert.assertTrue((boolean)b.equals((Object)new Fraction(Integer.MAX_VALUE)));
        Fraction c = new Fraction(2, Integer.MAX_VALUE);
        Fraction d = c.divide(2);
        Assert.assertTrue((boolean)d.equals((Object)new Fraction(1, Integer.MAX_VALUE)));
    }

    @Test
    public void testReciprocal() {
        Fraction f = null;
        f = new Fraction(50, 75);
        f = f.reciprocal();
        Assert.assertEquals((long)3L, (long)f.getNumerator());
        Assert.assertEquals((long)2L, (long)f.getDenominator());
        f = new Fraction(4, 3);
        f = f.reciprocal();
        Assert.assertEquals((long)3L, (long)f.getNumerator());
        Assert.assertEquals((long)4L, (long)f.getDenominator());
        f = new Fraction(-15, 47);
        f = f.reciprocal();
        Assert.assertEquals((long)-47L, (long)f.getNumerator());
        Assert.assertEquals((long)15L, (long)f.getDenominator());
        f = new Fraction(0, 3);
        try {
            f = f.reciprocal();
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        f = new Fraction(Integer.MAX_VALUE, 1);
        f = f.reciprocal();
        Assert.assertEquals((long)1L, (long)f.getNumerator());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getDenominator());
    }

    @Test
    public void testNegate() {
        Fraction f = null;
        f = new Fraction(50, 75);
        f = f.negate();
        Assert.assertEquals((long)-2L, (long)f.getNumerator());
        Assert.assertEquals((long)3L, (long)f.getDenominator());
        f = new Fraction(-50, 75);
        f = f.negate();
        Assert.assertEquals((long)2L, (long)f.getNumerator());
        Assert.assertEquals((long)3L, (long)f.getDenominator());
        f = new Fraction(0x7FFFFFFE, Integer.MAX_VALUE);
        f = f.negate();
        Assert.assertEquals((long)-2147483646L, (long)f.getNumerator());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getDenominator());
        f = new Fraction(Integer.MIN_VALUE, 1);
        try {
            f = f.negate();
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testAdd() {
        Fraction a = new Fraction(1, 2);
        Fraction b = new Fraction(2, 3);
        this.assertFraction(1, 1, a.add(a));
        this.assertFraction(7, 6, a.add(b));
        this.assertFraction(7, 6, b.add(a));
        this.assertFraction(4, 3, b.add(b));
        Fraction f1 = new Fraction(0x7FFFFFFE, 1);
        Fraction f2 = Fraction.ONE;
        Fraction f = f1.add(f2);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f = f1.add(1);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f1 = new Fraction(-1, 676);
        f2 = new Fraction(-2, 442);
        f = f1.add(f2);
        Assert.assertEquals((long)11492L, (long)f.getDenominator());
        Assert.assertEquals((long)-69L, (long)f.getNumerator());
        try {
            f.add(null);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        f1 = new Fraction(1, 98304);
        f2 = new Fraction(1, 59049);
        f = f1.add(f2);
        Assert.assertEquals((long)52451L, (long)f.getNumerator());
        Assert.assertEquals((long)1934917632L, (long)f.getDenominator());
        f1 = new Fraction(Integer.MIN_VALUE, 3);
        f2 = new Fraction(1, 3);
        f = f1.add(f2);
        Assert.assertEquals((long)-2147483647L, (long)f.getNumerator());
        Assert.assertEquals((long)3L, (long)f.getDenominator());
        f1 = new Fraction(0x7FFFFFFE, 1);
        f2 = Fraction.ONE;
        f = f1.add(f2);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        try {
            f = f.add(Fraction.ONE);
            Assert.fail((String)("expecting MathArithmeticException but got: " + f.toString()));
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        f1 = new Fraction(Integer.MIN_VALUE, 5);
        f2 = new Fraction(-1, 5);
        try {
            f = f1.add(f2);
            Assert.fail((String)("expecting MathArithmeticException but got: " + f.toString()));
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        try {
            f = new Fraction(-2147483647, 1);
            f = f.add(f);
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        try {
            f = new Fraction(-2147483647, 1);
            f = f.add(f);
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        f1 = new Fraction(3, 327680);
        f2 = new Fraction(2, 59049);
        try {
            f = f1.add(f2);
            Assert.fail((String)("expecting MathArithmeticException but got: " + f.toString()));
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testDivide() {
        Fraction a = new Fraction(1, 2);
        Fraction b = new Fraction(2, 3);
        this.assertFraction(1, 1, a.divide(a));
        this.assertFraction(3, 4, a.divide(b));
        this.assertFraction(4, 3, b.divide(a));
        this.assertFraction(1, 1, b.divide(b));
        Fraction f1 = new Fraction(3, 5);
        Fraction f2 = Fraction.ZERO;
        try {
            f1.divide(f2);
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        f1 = new Fraction(0, 5);
        f2 = new Fraction(2, 7);
        Fraction f = f1.divide(f2);
        Assert.assertSame((Object)Fraction.ZERO, (Object)f);
        f1 = new Fraction(2, 7);
        f2 = Fraction.ONE;
        f = f1.divide(f2);
        Assert.assertEquals((long)2L, (long)f.getNumerator());
        Assert.assertEquals((long)7L, (long)f.getDenominator());
        f1 = new Fraction(1, Integer.MAX_VALUE);
        f = f1.divide(f1);
        Assert.assertEquals((long)1L, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f1 = new Fraction(Integer.MIN_VALUE, Integer.MAX_VALUE);
        f2 = new Fraction(1, Integer.MAX_VALUE);
        f = f1.divide(f2);
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        try {
            f.divide(null);
            Assert.fail((String)"MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            f1 = new Fraction(1, Integer.MAX_VALUE);
            f = f1.divide(f1.reciprocal());
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        try {
            f1 = new Fraction(1, -2147483647);
            f = f1.divide(f1.reciprocal());
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        f1 = new Fraction(6, 35);
        f = f1.divide(15);
        Assert.assertEquals((long)2L, (long)f.getNumerator());
        Assert.assertEquals((long)175L, (long)f.getDenominator());
    }

    @Test
    public void testMultiply() {
        Fraction a = new Fraction(1, 2);
        Fraction b = new Fraction(2, 3);
        this.assertFraction(1, 4, a.multiply(a));
        this.assertFraction(1, 3, a.multiply(b));
        this.assertFraction(1, 3, b.multiply(a));
        this.assertFraction(4, 9, b.multiply(b));
        Fraction f1 = new Fraction(Integer.MAX_VALUE, 1);
        Fraction f2 = new Fraction(Integer.MIN_VALUE, Integer.MAX_VALUE);
        Fraction f = f1.multiply(f2);
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        try {
            f.multiply(null);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        f1 = new Fraction(6, 35);
        f = f1.multiply(15);
        Assert.assertEquals((long)18L, (long)f.getNumerator());
        Assert.assertEquals((long)7L, (long)f.getDenominator());
    }

    @Test
    public void testSubtract() {
        Fraction a = new Fraction(1, 2);
        Fraction b = new Fraction(2, 3);
        this.assertFraction(0, 1, a.subtract(a));
        this.assertFraction(-1, 6, a.subtract(b));
        this.assertFraction(1, 6, b.subtract(a));
        this.assertFraction(0, 1, b.subtract(b));
        Fraction f = new Fraction(1, 1);
        try {
            f.subtract(null);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        Fraction f1 = new Fraction(1, 98304);
        Fraction f2 = new Fraction(1, 59049);
        f = f1.subtract(f2);
        Assert.assertEquals((long)-13085L, (long)f.getNumerator());
        Assert.assertEquals((long)1934917632L, (long)f.getDenominator());
        f1 = new Fraction(Integer.MIN_VALUE, 3);
        f2 = new Fraction(1, 3).negate();
        f = f1.subtract(f2);
        Assert.assertEquals((long)-2147483647L, (long)f.getNumerator());
        Assert.assertEquals((long)3L, (long)f.getDenominator());
        f1 = new Fraction(Integer.MAX_VALUE, 1);
        f2 = Fraction.ONE;
        f = f1.subtract(f2);
        Assert.assertEquals((long)0x7FFFFFFEL, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        f = f1.subtract(1);
        Assert.assertEquals((long)0x7FFFFFFEL, (long)f.getNumerator());
        Assert.assertEquals((long)1L, (long)f.getDenominator());
        try {
            f1 = new Fraction(1, Integer.MAX_VALUE);
            f2 = new Fraction(1, 0x7FFFFFFE);
            f = f1.subtract(f2);
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        f1 = new Fraction(Integer.MIN_VALUE, 5);
        f2 = new Fraction(1, 5);
        try {
            f = f1.subtract(f2);
            Assert.fail((String)("expecting MathArithmeticException but got: " + f.toString()));
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        try {
            f = new Fraction(Integer.MIN_VALUE, 1);
            f = f.subtract(Fraction.ONE);
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        try {
            f = new Fraction(Integer.MAX_VALUE, 1);
            f = f.subtract(Fraction.ONE.negate());
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        f1 = new Fraction(3, 327680);
        f2 = new Fraction(2, 59049);
        try {
            f = f1.subtract(f2);
            Assert.fail((String)("expecting MathArithmeticException but got: " + f.toString()));
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testEqualsAndHashCode() {
        Fraction zero = new Fraction(0, 1);
        Object nullFraction = null;
        Assert.assertTrue((boolean)zero.equals((Object)zero));
        Assert.assertFalse((boolean)zero.equals(nullFraction));
        Assert.assertFalse((boolean)zero.equals((Object)0.0));
        Fraction zero2 = new Fraction(0, 2);
        Assert.assertTrue((boolean)zero.equals((Object)zero2));
        Assert.assertEquals((long)zero.hashCode(), (long)zero2.hashCode());
        Fraction one = new Fraction(1, 1);
        Assert.assertFalse((one.equals((Object)zero) || zero.equals((Object)one) ? 1 : 0) != 0);
    }

    @Test
    public void testGetReducedFraction() {
        Fraction threeFourths = new Fraction(3, 4);
        Assert.assertTrue((boolean)threeFourths.equals((Object)Fraction.getReducedFraction((int)6, (int)8)));
        Assert.assertTrue((boolean)Fraction.ZERO.equals((Object)Fraction.getReducedFraction((int)0, (int)-1)));
        try {
            Fraction.getReducedFraction((int)1, (int)0);
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        Assert.assertEquals((long)Fraction.getReducedFraction((int)2, (int)Integer.MIN_VALUE).getNumerator(), (long)-1L);
        Assert.assertEquals((long)Fraction.getReducedFraction((int)1, (int)-1).getNumerator(), (long)-1L);
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"0", (Object)new Fraction(0, 3).toString());
        Assert.assertEquals((Object)"3", (Object)new Fraction(6, 2).toString());
        Assert.assertEquals((Object)"2 / 3", (Object)new Fraction(18, 27).toString());
    }

    @Test
    public void testSerial() throws FractionConversionException {
        Fraction[] fractions;
        for (Fraction fraction : fractions = new Fraction[]{new Fraction(3, 4), Fraction.ONE, Fraction.ZERO, new Fraction(17), new Fraction(Math.PI, 1000), new Fraction(-5, 2)}) {
            Assert.assertEquals((Object)fraction, (Object)TestUtils.serializeAndRecover(fraction));
        }
    }
}

