/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.tags.junit.SuiteTag;

public class CaseTag
extends TagSupport {
    private String name;

    public void doTag(final XMLOutput output) throws JellyTagException {
        String name = this.getName();
        if (name == null) {
            name = ((Object)((Object)this)).toString();
        }
        TestCase testCase = new TestCase(name){

            protected void runTest() throws Throwable {
                JellyContext newContext = new JellyContext(CaseTag.this.context);
                newContext.setExportLibraries(false);
                newContext.setExport(false);
                CaseTag.this.getBody().run(newContext, output);
            }
        };
        TestSuite suite = this.getSuite();
        if (suite == null) {
            throw new JellyTagException("Could not find a TestSuite to add this test to. This tag should be inside a <test:suite> tag");
        }
        suite.addTest((Test)testCase);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected TestSuite getSuite() {
        SuiteTag tag = (SuiteTag)this.findAncestorWithClass(SuiteTag.class);
        if (tag != null) {
            return tag.getSuite();
        }
        return (TestSuite)this.context.getVariable("org.apache.commons.jelly.junit.suite");
    }
}

