/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.jdbc.mysql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.TableState;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.mysql.MySQLDiskCacheAttributes;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.timing.ElapsedTimer;

public class MySQLTableOptimizer {
    private static final Log log = LogManager.getLog(MySQLTableOptimizer.class);
    private final DataSource dataSource;
    private String tableName;
    private final TableState tableState;

    public MySQLTableOptimizer(MySQLDiskCacheAttributes attributes, TableState tableState, DataSource dataSource) {
        this.setTableName(attributes.getTableName());
        this.tableState = tableState;
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean optimizeTable() {
        ElapsedTimer timer = new ElapsedTimer();
        boolean success = false;
        if (this.tableState.getState() == 2) {
            log.warn("Skipping optimization. Optimize was called, but the table state indicates that an optimization is currently running.");
            return false;
        }
        try {
            this.tableState.setState(2);
            log.info("Optimizing table [{0}]", this.getTableName());
            try {
                Connection con;
                block30: {
                    con = this.dataSource.getConnection();
                    try (Statement sStatement = con.createStatement();){
                        block29: {
                            try (ResultSet rs = sStatement.executeQuery("optimize table " + this.getTableName());){
                                if (!rs.next()) break block29;
                                String status = rs.getString("Msg_type");
                                String message = rs.getString("Msg_text");
                                log.info("Message Type: {0}", status);
                                log.info("Message: {0}", message);
                                if ("error".equals(status)) {
                                    log.warn("Optimization was in error. Will attempt to repair the table. Message: {0}", message);
                                    success = this.repairTable(sStatement);
                                } else {
                                    success = true;
                                }
                            }
                        }
                        String statusString = this.getTableStatus(sStatement);
                        log.info("Table status after optimizing table [{0}]: {1}", this.getTableName(), statusString);
                        break block30;
                    }
                    catch (SQLException e) {
                        log.error("Problem optimizing table [{0}]", this.getTableName(), e);
                        boolean bl = false;
                        if (con != null) {
                            con.close();
                        }
                        this.tableState.setState(0);
                        Supplier[] supplierArray = new Supplier[2];
                        supplierArray[0] = this::getTableName;
                        supplierArray[1] = timer::getElapsedTime;
                        log.info("Optimization of table [{0}] took {1} ms.", supplierArray);
                        return bl;
                    }
                    {
                        catch (Throwable throwable) {
                            if (con == null) throw throwable;
                            try {
                                con.close();
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                log.error("Problem getting connection.", e);
            }
            this.tableState.setState(0);
        }
        catch (Throwable throwable) {
            this.tableState.setState(0);
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = this::getTableName;
            supplierArray[1] = timer::getElapsedTime;
            log.info("Optimization of table [{0}] took {1} ms.", supplierArray);
            throw throwable;
        }
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = this::getTableName;
        supplierArray[1] = timer::getElapsedTime;
        log.info("Optimization of table [{0}] took {1} ms.", supplierArray);
        return success;
    }

    protected String getTableStatus(Statement sStatement) throws SQLException {
        StringBuilder statusString = new StringBuilder();
        try (ResultSet statusResultSet = sStatement.executeQuery("show table status");){
            int numColumns = statusResultSet.getMetaData().getColumnCount();
            while (statusResultSet.next()) {
                statusString.append("\n");
                for (int i = 1; i <= numColumns; ++i) {
                    statusString.append(statusResultSet.getMetaData().getColumnLabel(i)).append(" [").append(statusResultSet.getString(i)).append("]  |  ");
                }
            }
        }
        return statusString.toString();
    }

    protected boolean repairTable(Statement sStatement) throws SQLException {
        boolean success = false;
        StringBuilder repairString = new StringBuilder();
        try (ResultSet repairResult = sStatement.executeQuery("repair table " + this.getTableName());){
            int numColumns = repairResult.getMetaData().getColumnCount();
            while (repairResult.next()) {
                for (int i = 1; i <= numColumns; ++i) {
                    repairString.append(repairResult.getMetaData().getColumnLabel(i)).append(" [").append(repairResult.getString(i)).append("]  |  ");
                }
                String message = repairResult.getString("Msg_text");
                if (!"OK".equals(message)) continue;
                success = true;
            }
        }
        log.info("{0}", repairString);
        if (!success) {
            log.warn("Failed to repair the table. {0}", repairString);
        }
        return success;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }
}

