/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.file.Path;
import org.apache.commons.imaging.FormatCompliance;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.formats.tiff.AbstractTiffElement;
import org.apache.commons.imaging.formats.tiff.AbstractTiffImageData;
import org.apache.commons.imaging.formats.tiff.AbstractTiffRasterData;
import org.apache.commons.imaging.formats.tiff.AbstractTiffTest;
import org.apache.commons.imaging.formats.tiff.TiffContents;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.formats.tiff.TiffReader;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.write.TiffImageWriterLossy;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TiffShortIntRoundTripTest
extends AbstractTiffTest {
    @TempDir
    Path tempDir;
    int width = 48;
    int height = 23;
    short[] sample = new short[this.width * this.height];

    public TiffShortIntRoundTripTest() {
        for (int iCol = 0; iCol < this.width; ++iCol) {
            for (int iRow = 0; iRow < this.height; ++iRow) {
                int index = iRow * this.width + iCol;
                this.sample[index] = (short)(index - 10);
            }
        }
    }

    private byte[][] getBytesForOutput16(short[] s, int width, int height, int nRowsInBlock, int nColsInBlock, ByteOrder byteOrder) {
        int nColsOfBlocks = (width + nColsInBlock - 1) / nColsInBlock;
        int nRowsOfBlocks = (height + nRowsInBlock + 1) / nRowsInBlock;
        int bytesPerPixel = 2;
        int nBlocks = nRowsOfBlocks * nColsOfBlocks;
        int nBytesInBlock = 2 * nRowsInBlock * nColsInBlock;
        byte[][] blocks = new byte[nBlocks][nBytesInBlock];
        for (int i = 0; i < height; ++i) {
            int blockRow = i / nRowsInBlock;
            int rowInBlock = i - blockRow * nRowsInBlock;
            int blockOffset = rowInBlock * nColsInBlock;
            for (int j = 0; j < width; ++j) {
                short value = s[i * width + j];
                int blockCol = j / nColsInBlock;
                int colInBlock = j - blockCol * nColsInBlock;
                int index = blockOffset + colInBlock;
                int offset = index * 2;
                byte[] b = blocks[blockRow * nColsOfBlocks + blockCol];
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    b[offset] = (byte)(value & 0xFF);
                    b[offset + 1] = (byte)(value >> 8 & 0xFF);
                    continue;
                }
                b[offset] = (byte)(value >> 8 & 0xFF);
                b[offset + 1] = (byte)(value & 0xFF);
            }
        }
        return blocks;
    }

    @Test
    public void test() throws Exception {
        File[] testFile = new File[]{this.writeFile(16, ByteOrder.LITTLE_ENDIAN, false), this.writeFile(16, ByteOrder.BIG_ENDIAN, false), this.writeFile(16, ByteOrder.LITTLE_ENDIAN, true), this.writeFile(16, ByteOrder.BIG_ENDIAN, true)};
        for (int i = 0; i < testFile.length; ++i) {
            String name = testFile[i].getName();
            ByteSource byteSource = ByteSource.file((File)testFile[i]);
            TiffReader tiffReader = new TiffReader(true);
            TiffContents contents = tiffReader.readDirectories(byteSource, true, FormatCompliance.getDefault());
            TiffDirectory directory = (TiffDirectory)contents.directories.get(0);
            AbstractTiffRasterData rdInt = directory.getRasterData(null);
            int[] test = rdInt.getIntData();
            for (int j = 0; j < this.sample.length; ++j) {
                Assertions.assertEquals((int)this.sample[j], (int)test[j], (String)("Extracted data does not match original, test " + name + ": " + i + ", index " + j));
            }
            TiffImagingParameters params = new TiffImagingParameters();
            params.setSubImage(2, 2, this.width - 4, this.height - 4);
            AbstractTiffRasterData rdSub = directory.getRasterData(params);
            Assertions.assertEquals((int)(this.width - 4), (int)rdSub.getWidth(), (String)"Invalid sub-image width");
            Assertions.assertEquals((int)(this.height - 4), (int)rdSub.getHeight(), (String)"Invalid sub-image height");
            for (int x = 2; x < this.width - 2; ++x) {
                for (int y = 2; y < this.height - 2; ++y) {
                    int a = rdInt.getIntValue(x, y);
                    int b = rdSub.getIntValue(x - 2, y - 2);
                    Assertions.assertEquals((int)a, (int)b, (String)("Sub Image test failed at (" + x + "," + y + ")"));
                }
            }
            TiffImagingParameters xparams = new TiffImagingParameters();
            xparams.setSubImage(2, 2, this.width, this.height);
            Assertions.assertThrows(ImagingException.class, () -> directory.getRasterData(xparams), (String)("Failed to catch bad subimage for test " + name));
        }
    }

    private File writeFile(int bitsPerSample, ByteOrder byteOrder, boolean useTiles) throws IOException, ImagingException {
        int nColsInBlock;
        int nRowsInBlock;
        String name = String.format("ShortIntRoundTrip_%2d_%s_%s.tiff", bitsPerSample, byteOrder == ByteOrder.LITTLE_ENDIAN ? "LE" : "BE", useTiles ? "Tiles" : "Strips");
        File outputFile = new File(this.tempDir.toFile(), name);
        int bytesPerSample = bitsPerSample / 8;
        if (useTiles) {
            nRowsInBlock = 12;
            nColsInBlock = 20;
        } else {
            nRowsInBlock = 2;
            nColsInBlock = this.width;
        }
        int nBytesInBlock = nRowsInBlock * nColsInBlock * bytesPerSample;
        byte[][] blocks = this.getBytesForOutput16(this.sample, this.width, this.height, nRowsInBlock, nColsInBlock, byteOrder);
        TiffOutputSet outputSet = new TiffOutputSet(byteOrder);
        TiffOutputDirectory outDir = outputSet.addRootDirectory();
        outDir.add(TiffTagConstants.TIFF_TAG_IMAGE_WIDTH, new int[]{this.width});
        outDir.add(TiffTagConstants.TIFF_TAG_IMAGE_LENGTH, new int[]{this.height});
        outDir.add(TiffTagConstants.TIFF_TAG_SAMPLE_FORMAT, new short[]{2});
        outDir.add(TiffTagConstants.TIFF_TAG_SAMPLES_PER_PIXEL, (short)1);
        outDir.add(TiffTagConstants.TIFF_TAG_BITS_PER_SAMPLE, new short[]{(short)bitsPerSample});
        outDir.add(TiffTagConstants.TIFF_TAG_PHOTOMETRIC_INTERPRETATION, (short)1);
        outDir.add(TiffTagConstants.TIFF_TAG_COMPRESSION, (short)1);
        outDir.add(TiffTagConstants.TIFF_TAG_PLANAR_CONFIGURATION, (short)1);
        if (useTiles) {
            outDir.add(TiffTagConstants.TIFF_TAG_TILE_WIDTH, new int[]{nColsInBlock});
            outDir.add(TiffTagConstants.TIFF_TAG_TILE_LENGTH, new int[]{nRowsInBlock});
            outDir.add(TiffTagConstants.TIFF_TAG_TILE_BYTE_COUNTS, new int[]{nBytesInBlock});
        } else {
            outDir.add(TiffTagConstants.TIFF_TAG_ROWS_PER_STRIP, new int[]{nRowsInBlock});
            outDir.add(TiffTagConstants.TIFF_TAG_STRIP_BYTE_COUNTS, new int[]{nBytesInBlock});
        }
        AbstractTiffElement.DataElement[] imageData = new AbstractTiffElement.DataElement[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            imageData[i] = new AbstractTiffImageData.Data(0L, blocks[i].length, blocks[i]);
        }
        Object abstractTiffImageData = useTiles ? new AbstractTiffImageData.Tiles(imageData, nColsInBlock, nRowsInBlock) : new AbstractTiffImageData.Strips(imageData, nRowsInBlock);
        outDir.setTiffImageData((AbstractTiffImageData)abstractTiffImageData);
        try (FileOutputStream fos = new FileOutputStream(outputFile);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            TiffImageWriterLossy writer = new TiffImageWriterLossy(byteOrder);
            writer.write((OutputStream)bos, outputSet);
            bos.flush();
        }
        return outputFile;
    }
}

