/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed.obj;

import java.util.ArrayList;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.io.core.internal.SimpleTextParser;

public abstract class AbstractObjParser {
    private final SimpleTextParser parser;
    private String currentKeyword;

    protected AbstractObjParser(SimpleTextParser parser) {
        this.parser = parser;
    }

    public String getCurrentKeyword() {
        return this.currentKeyword;
    }

    public boolean nextKeyword() {
        this.currentKeyword = null;
        if (this.parser.getColumnNumber() != 1) {
            this.discardDataLine();
        }
        while (this.currentKeyword == null && this.parser.hasMoreCharacters()) {
            if (!this.nextDataLineContent() || this.parser.peekChar() == 35) {
                this.parser.discardLine();
                continue;
            }
            if (this.parser.getColumnNumber() != 1) {
                throw this.parser.parseError("non-blank lines must begin with an OBJ keyword or comment character");
            }
            if (!this.readKeyword()) {
                throw this.parser.unexpectedToken("OBJ keyword");
            }
            String keywordValue = this.parser.getCurrentToken();
            this.handleKeyword(keywordValue);
            this.currentKeyword = keywordValue;
            this.discardDataLineWhitespace();
        }
        return this.currentKeyword != null;
    }

    public String readDataLine() {
        this.parser.nextWithLineContinuation('\\', SimpleTextParser::isNotNewLinePart).discardNewLineSequence();
        return this.parser.getCurrentToken();
    }

    public void discardDataLine() {
        this.parser.discardWithLineContinuation('\\', SimpleTextParser::isNotNewLinePart).discardNewLineSequence();
    }

    public Vector3D readVector() {
        this.discardDataLineWhitespace();
        double x = this.nextDouble();
        this.discardDataLineWhitespace();
        double y = this.nextDouble();
        this.discardDataLineWhitespace();
        double z = this.nextDouble();
        return Vector3D.of((double)x, (double)y, (double)z);
    }

    public double[] readDoubles() {
        ArrayList<Double> list = new ArrayList<Double>();
        while (this.nextDataLineContent()) {
            list.add(this.nextDouble());
        }
        double[] arr = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = (Double)list.get(i);
        }
        return arr;
    }

    protected SimpleTextParser getTextParser() {
        return this.parser;
    }

    protected abstract void handleKeyword(String var1);

    protected SimpleTextParser discardDataLineWhitespace() {
        return this.parser.discardWithLineContinuation('\\', SimpleTextParser::isLineWhitespace);
    }

    protected boolean nextDataLineContent() {
        return this.discardDataLineWhitespace().hasMoreCharactersOnLine();
    }

    protected double nextDouble() {
        return this.parser.nextWithLineContinuation('\\', SimpleTextParser::isNotWhitespace).getCurrentTokenAsDouble();
    }

    private boolean readKeyword() {
        return this.parser.nextWithLineContinuation('\\', SimpleTextParser::isAlphanumeric).hasNonEmptyToken();
    }
}

