/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.MockHttpServletRequest;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.junit.Assert;
import org.junit.Test;

public class ProgressListenerTest {
    private void runTest(int numItems, long contentLength, MockHttpServletRequest request) throws FileUploadException, IOException {
        ServletFileUpload upload = new ServletFileUpload();
        ProgressListenerImpl listener = new ProgressListenerImpl(contentLength, numItems);
        upload.setProgressListener((ProgressListener)listener);
        FileItemIterator iter = upload.getItemIterator((HttpServletRequest)request);
        for (int i = 0; i < numItems; ++i) {
            FileItemStream stream = iter.next();
            try (InputStream istream = stream.openStream();){
                int maxIn = 16384;
                for (int j = 0; j < 16384 + i; ++j) {
                    byte b1 = (byte)j;
                    byte b2 = (byte)istream.read();
                    if (b1 == b2) continue;
                    Assert.fail((String)("Expected " + b1 + ", got " + b2));
                }
                Assert.assertEquals((long)-1L, (long)istream.read());
                continue;
            }
        }
        Assert.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        listener.checkFinished();
    }

    @Test
    public void testProgressListener() throws Exception {
        int numItems = 512;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < 512; ++i) {
            String header = "-----1234\r\nContent-Disposition: form-data; name=\"field" + (i + 1) + "\"\r\n\r\n";
            baos.write(header.getBytes("US-ASCII"));
            int maxOut = 16384;
            for (int j = 0; j < 16384 + i; ++j) {
                baos.write((byte)j);
            }
            baos.write("\r\n".getBytes("US-ASCII"));
        }
        baos.write("-----1234--\r\n".getBytes("US-ASCII"));
        byte[] contents = baos.toByteArray();
        MockHttpServletRequest request = new MockHttpServletRequest(contents, "multipart/form-data; boundary=---1234");
        this.runTest(512, contents.length, request);
        request = new MockHttpServletRequest(contents, "multipart/form-data; boundary=---1234"){

            @Override
            public int getContentLength() {
                return -1;
            }
        };
        this.runTest(512, contents.length, request);
    }

    private static class ProgressListenerImpl
    implements ProgressListener {
        private final long expectedContentLength;
        private final int expectedItems;
        private Long bytesRead;
        private Integer items;

        ProgressListenerImpl(long expectedContentLength, int expectedItems) {
            this.expectedContentLength = expectedContentLength;
            this.expectedItems = expectedItems;
        }

        void checkFinished() {
            Assert.assertEquals((long)this.expectedContentLength, (long)this.bytesRead);
            Assert.assertEquals((long)this.expectedItems, (long)this.items.intValue());
        }

        public void update(long actualBytesRead, long actualContentLength, int actualItems) {
            Assert.assertTrue((actualBytesRead >= 0L && actualBytesRead <= this.expectedContentLength ? 1 : 0) != 0);
            Assert.assertTrue((actualContentLength == -1L || actualContentLength == this.expectedContentLength ? 1 : 0) != 0);
            Assert.assertTrue((actualItems >= 0 && actualItems <= this.expectedItems ? 1 : 0) != 0);
            Assert.assertTrue((this.bytesRead == null || actualBytesRead >= this.bytesRead ? 1 : 0) != 0);
            this.bytesRead = actualBytesRead;
            Assert.assertTrue((this.items == null || actualItems >= this.items ? 1 : 0) != 0);
            this.items = actualItems;
        }
    }
}

