/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils.handlers.properties;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.dbutils.handlers.properties.DatePropertyHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DatePropertyHandlerTest {
    private DatePropertyHandler handler;
    private Date testValue;

    @Before
    public void setUp() {
        this.handler = new DatePropertyHandler();
        this.testValue = new Date();
    }

    @Test
    public void testApplyTypeOfDate() throws Exception {
        Assert.assertEquals(java.sql.Date.class, this.handler.apply(java.sql.Date.class, (Object)this.testValue).getClass());
    }

    @Test
    public void testApplyTypeOfTime() throws Exception {
        Assert.assertEquals(Time.class, this.handler.apply(Time.class, (Object)this.testValue).getClass());
    }

    @Test
    public void testApplyTypeOfTimestamp() throws Exception {
        Assert.assertEquals(Timestamp.class, this.handler.apply(Timestamp.class, (Object)this.testValue).getClass());
    }

    @Test
    public void testMatch() {
        Assert.assertTrue((boolean)this.handler.match(java.sql.Date.class, (Object)this.testValue));
        Assert.assertTrue((boolean)this.handler.match(Time.class, (Object)this.testValue));
        Assert.assertTrue((boolean)this.handler.match(Timestamp.class, (Object)this.testValue));
    }

    @Test
    public void testMatchNegative() {
        Assert.assertFalse((boolean)this.handler.match(Float.class, null));
        Assert.assertFalse((boolean)this.handler.match(Float.class, (Object)this.testValue));
    }

    @Test
    public void testNotMatch() {
        Timestamp ts = new Timestamp(this.testValue.getTime());
        Assert.assertFalse((boolean)this.handler.match(Timestamp.class, (Object)ts));
    }
}

