/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.time.Duration;
import org.apache.commons.dbutils.StatementConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class StatementConfigurationTest {
    @Test
    public void testBuilder() {
        StatementConfiguration.Builder builder = new StatementConfiguration.Builder().fetchDirection(Integer.valueOf(1)).fetchSize(Integer.valueOf(2)).maxFieldSize(Integer.valueOf(3)).maxRows(Integer.valueOf(4)).queryTimeout(Integer.valueOf(5));
        StatementConfiguration config = builder.build();
        Assert.assertTrue((boolean)config.isFetchDirectionSet());
        Assert.assertEquals((Object)1, (Object)config.getFetchDirection());
        Assert.assertTrue((boolean)config.isFetchSizeSet());
        Assert.assertEquals((Object)2, (Object)config.getFetchSize());
        Assert.assertTrue((boolean)config.isMaxFieldSizeSet());
        Assert.assertEquals((Object)3, (Object)config.getMaxFieldSize());
        Assert.assertTrue((boolean)config.isMaxRowsSet());
        Assert.assertEquals((Object)4, (Object)config.getMaxRows());
        Assert.assertTrue((boolean)config.isQueryTimeoutSet());
        Assert.assertEquals((Object)5, (Object)config.getQueryTimeout());
        Assert.assertTrue((boolean)config.isQueryTimeoutSet());
        Assert.assertEquals((Object)Duration.ofSeconds(5L), (Object)config.getQueryTimeoutDuration());
        StatementConfiguration config2 = builder.queryTimeout(Duration.ofSeconds(3L)).build();
        Assert.assertTrue((boolean)config2.isQueryTimeoutSet());
        Assert.assertEquals((Object)3, (Object)config2.getQueryTimeout());
        Assert.assertTrue((boolean)config2.isQueryTimeoutSet());
        Assert.assertEquals((Object)Duration.ofSeconds(3L), (Object)config2.getQueryTimeoutDuration());
    }

    @Test
    public void testConstructor() {
        StatementConfiguration config = new StatementConfiguration(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5));
        Assert.assertEquals((Object)1, (Object)config.getFetchDirection());
        Assert.assertEquals((Object)2, (Object)config.getFetchSize());
        Assert.assertEquals((Object)3, (Object)config.getMaxFieldSize());
        Assert.assertEquals((Object)4, (Object)config.getMaxRows());
        Assert.assertEquals((Object)5, (Object)config.getQueryTimeout());
    }

    @Test
    public void testEmptyBuilder() {
        StatementConfiguration config = new StatementConfiguration.Builder().build();
        Assert.assertFalse((boolean)config.isFetchDirectionSet());
        Assert.assertFalse((boolean)config.isFetchSizeSet());
        Assert.assertFalse((boolean)config.isMaxFieldSizeSet());
        Assert.assertFalse((boolean)config.isMaxRowsSet());
        Assert.assertFalse((boolean)config.isQueryTimeoutSet());
    }
}

