/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.random;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.crypto.random.CryptoRandom;
import org.apache.commons.crypto.utils.IoUtils;

final class OsCryptoRandom
implements CryptoRandom {
    private static final int RESERVOIR_LENGTH = 8192;
    private transient FileInputStream stream;
    private final byte[] reservoir = new byte[8192];
    private int pos = this.reservoir.length;

    public OsCryptoRandom(Properties props) {
        File randomDevFile = new File(props.getProperty("commons.crypto.secure.random.device.file.path", "/dev/urandom"));
        try {
            this.close();
            this.stream = new FileInputStream(randomDevFile);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            this.fillReservoir(0);
        }
        catch (IllegalStateException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public synchronized void close() {
        if (this.stream != null) {
            IoUtils.closeQuietly(this.stream);
            this.stream = null;
        }
    }

    private void fillReservoir(int min) {
        if (this.pos >= this.reservoir.length - min) {
            try {
                IoUtils.readFully(this.stream, this.reservoir, 0, this.reservoir.length);
            }
            catch (IOException e) {
                throw new IllegalStateException("failed to fill reservoir", e);
            }
            this.pos = 0;
        }
    }

    @Override
    public synchronized void nextBytes(byte[] bytes) {
        int off = 0;
        int n = 0;
        while (off < bytes.length) {
            this.fillReservoir(0);
            n = Math.min(bytes.length - off, this.reservoir.length - this.pos);
            System.arraycopy(this.reservoir, this.pos, bytes, off, n);
            off += n;
            this.pos += n;
        }
    }
}

