/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Deque;
import java.util.Iterator;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.PropertiesConfigurationLayout;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.LegacyListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestPropertiesConfigurationLayout {
    private static final String CR = System.lineSeparator();
    private static final String CRNORM = "\n";
    private static final String TEST_KEY = "myProperty";
    private static final String TEST_COMMENT = "A comment for my test property";
    private static final String TEST_VALUE = "myPropertyValue";
    private PropertiesConfigurationLayout layout;
    private LayoutTestConfiguration config;
    private PropertiesBuilder builder;

    private void checkLayoutString(String expected) throws ConfigurationException {
        Assertions.assertEquals((Object)expected, (Object)this.getLayoutString());
    }

    private void fillLayout() {
        this.builder.addComment("A header comment");
        this.builder.addComment(null);
        this.builder.addProperty("prop", "value");
        this.builder.addComment(TEST_COMMENT);
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.builder.addProperty("anotherProp", "anotherValue");
        this.builder.addComment("A footer comment");
        Assertions.assertDoesNotThrow(() -> this.layout.load((PropertiesConfiguration)this.config, this.builder.getReader()));
    }

    private String getLayoutString() throws ConfigurationException {
        StringWriter out = new StringWriter();
        this.layout.save((PropertiesConfiguration)this.config, (Writer)out);
        return out.toString();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.config = new LayoutTestConfiguration();
        this.config.setListDelimiterHandler((ListDelimiterHandler)new LegacyListDelimiterHandler(','));
        this.layout = new PropertiesConfigurationLayout();
        this.config.setLayout(this.layout);
        this.builder = new PropertiesBuilder();
    }

    @Test
    void testBlankLines() throws ConfigurationException {
        this.builder.addProperty("prop", "value");
        this.builder.addComment(null);
        this.builder.addComment(null);
        this.builder.addComment(TEST_COMMENT);
        this.builder.addComment(null);
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.load((PropertiesConfiguration)this.config, this.builder.getReader());
        Assertions.assertEquals((int)2, (int)this.layout.getBlankLinesBefore(TEST_KEY));
        Assertions.assertEquals((Object)"A comment for my test property\n", (Object)this.layout.getCanonicalComment(TEST_KEY, false));
        Assertions.assertEquals((Object)TEST_VALUE, (Object)this.config.getString(TEST_KEY));
    }

    @Test
    void testBlankLinesWithHeaderComment() throws ConfigurationException {
        this.builder.addComment(TEST_COMMENT);
        this.builder.addComment(null);
        this.builder.addComment(null);
        this.builder.addComment(TEST_COMMENT);
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.load((PropertiesConfiguration)this.config, this.builder.getReader());
        Assertions.assertEquals((int)2, (int)this.layout.getBlankLinesBefore(TEST_KEY));
        Assertions.assertEquals((Object)TEST_COMMENT, (Object)this.layout.getCanonicalComment(TEST_KEY, false));
        Assertions.assertEquals((Object)TEST_VALUE, (Object)this.config.getString(TEST_KEY));
    }

    @Test
    void testCombineComments() throws ConfigurationException {
        this.builder.addComment(TEST_COMMENT);
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.builder.addComment(null);
        this.builder.addComment(TEST_COMMENT);
        this.builder.addProperty(TEST_KEY, "myPropertyValue2");
        this.layout.load((PropertiesConfiguration)this.config, this.builder.getReader());
        Assertions.assertEquals((Object)"A comment for my test property\nA comment for my test property", (Object)this.layout.getCanonicalComment(TEST_KEY, false));
        Assertions.assertEquals((int)0, (int)this.layout.getBlankLinesBefore(TEST_KEY));
    }

    @Test
    void testEventAdd() {
        ConfigurationEvent event = new ConfigurationEvent((Object)this, ConfigurationEvent.ADD_PROPERTY, TEST_KEY, (Object)TEST_VALUE, false);
        this.layout.onEvent(event);
        Assertions.assertTrue((boolean)this.layout.getKeys().contains(TEST_KEY));
        Assertions.assertEquals((int)0, (int)this.layout.getBlankLinesBefore(TEST_KEY));
        Assertions.assertTrue((boolean)this.layout.isSingleLine(TEST_KEY));
        Assertions.assertEquals((Object)" = ", (Object)this.layout.getSeparator(TEST_KEY));
    }

    @Test
    void testEventAddBefore() {
        ConfigurationEvent event = new ConfigurationEvent((Object)this, ConfigurationEvent.ADD_PROPERTY, TEST_KEY, (Object)TEST_VALUE, true);
        this.layout.onEvent(event);
        Assertions.assertFalse((boolean)this.layout.getKeys().contains(TEST_KEY));
    }

    @Test
    void testEventAddExisting() throws ConfigurationException {
        this.builder.addComment(TEST_COMMENT);
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.load((PropertiesConfiguration)this.config, this.builder.getReader());
        ConfigurationEvent event = new ConfigurationEvent((Object)this, ConfigurationEvent.ADD_PROPERTY, TEST_KEY, (Object)TEST_VALUE, false);
        this.layout.onEvent(event);
        Assertions.assertFalse((boolean)this.layout.isSingleLine(TEST_KEY));
        Assertions.assertEquals((Object)TEST_COMMENT, (Object)this.layout.getCanonicalComment(TEST_KEY, false));
    }

    @Test
    void testEventAddMultiple() {
        ConfigurationEvent event = new ConfigurationEvent((Object)this, ConfigurationEvent.ADD_PROPERTY, TEST_KEY, (Object)TEST_VALUE, false);
        this.layout.onEvent(event);
        this.layout.onEvent(event);
        Assertions.assertFalse((boolean)this.layout.isSingleLine(TEST_KEY));
    }

    @Test
    void testEventClearConfig() throws Exception {
        this.fillLayout();
        ConfigurationEvent event = new ConfigurationEvent((Object)this, ConfigurationEvent.CLEAR, null, null, false);
        this.layout.onEvent(event);
        Assertions.assertTrue((boolean)this.layout.getKeys().isEmpty());
        Assertions.assertNull((Object)this.layout.getHeaderComment());
    }

    @Test
    void testEventDelete() {
        ConfigurationEvent event = new ConfigurationEvent((Object)this, ConfigurationEvent.ADD_PROPERTY, TEST_KEY, (Object)TEST_VALUE, false);
        this.layout.onEvent(event);
        event = new ConfigurationEvent((Object)this, ConfigurationEvent.CLEAR_PROPERTY, TEST_KEY, null, false);
        this.layout.onEvent(event);
        Assertions.assertFalse((boolean)this.layout.getKeys().contains(TEST_KEY));
    }

    @Test
    void testEventSetNonExisting() {
        ConfigurationEvent event = new ConfigurationEvent((Object)this, ConfigurationEvent.SET_PROPERTY, TEST_KEY, (Object)TEST_VALUE, false);
        this.layout.onEvent(event);
        Assertions.assertTrue((boolean)this.layout.getKeys().contains(TEST_KEY));
    }

    @Test
    void testGetNonExistingLayouData() {
        Assertions.assertNull((Object)this.layout.getComment("unknown"));
        Assertions.assertTrue((boolean)this.layout.isSingleLine("unknown"));
        Assertions.assertEquals((int)0, (int)this.layout.getBlankLinesBefore("unknown"));
    }

    @Test
    void testGetNullLayouttData() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.layout.setComment(null, TEST_COMMENT));
    }

    @Test
    void testHeaderComment() throws ConfigurationException {
        this.builder.addComment(TEST_COMMENT);
        this.builder.addComment(null);
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.load((PropertiesConfiguration)this.config, this.builder.getReader());
        Assertions.assertEquals((Object)TEST_COMMENT, (Object)this.layout.getCanonicalHeaderComment(false));
        Assertions.assertNull((Object)this.layout.getCanonicalComment(TEST_KEY, false));
    }

    @Test
    void testHeaderCommentNull() {
        Assertions.assertNull((Object)this.layout.getCanonicalHeaderComment(true));
        Assertions.assertNull((Object)this.layout.getCanonicalHeaderComment(false));
    }

    @Test
    void testHeaderCommentWithBlanks() throws ConfigurationException {
        this.builder.addComment(TEST_COMMENT);
        this.builder.addComment(null);
        this.builder.addComment(TEST_COMMENT);
        this.builder.addComment(null);
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.load((PropertiesConfiguration)this.config, this.builder.getReader());
        Assertions.assertEquals((Object)"A comment for my test property\n\nA comment for my test property", (Object)this.layout.getCanonicalHeaderComment(false));
        Assertions.assertNull((Object)this.layout.getComment(TEST_KEY));
    }

    @Test
    void testHeaderCommentWithBlanksAndPresetHeaderComment() throws ConfigurationException {
        String presetHeaderComment = "presetA comment for my test property\n\nA comment for my test property";
        this.builder.addComment(TEST_COMMENT);
        this.builder.addComment(null);
        this.builder.addComment(TEST_COMMENT);
        this.builder.addComment(null);
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.setHeaderComment("presetA comment for my test property\n\nA comment for my test property");
        this.layout.load((PropertiesConfiguration)this.config, this.builder.getReader());
        Assertions.assertEquals((Object)"presetA comment for my test property\n\nA comment for my test property", (Object)this.layout.getCanonicalHeaderComment(false));
        Assertions.assertNull((Object)this.layout.getComment(TEST_KEY));
    }

    @Test
    void testHeaderCommentWithBlanksAndPropComment() throws ConfigurationException {
        this.builder.addComment(TEST_COMMENT);
        this.builder.addComment(null);
        this.builder.addComment(TEST_COMMENT);
        this.builder.addComment(null);
        this.builder.addComment(TEST_COMMENT);
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.load((PropertiesConfiguration)this.config, this.builder.getReader());
        Assertions.assertEquals((Object)"A comment for my test property\n\nA comment for my test property", (Object)this.layout.getCanonicalHeaderComment(false));
        Assertions.assertEquals((Object)TEST_COMMENT, (Object)this.layout.getCanonicalComment(TEST_KEY, false));
    }

    @Test
    void testInit() {
        Assertions.assertTrue((boolean)this.layout.getKeys().isEmpty());
        Assertions.assertNull((Object)this.layout.getHeaderComment());
        Iterator it = this.config.getEventListeners(ConfigurationEvent.ANY).iterator();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertSame((Object)this.layout, it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertFalse((boolean)this.layout.isForceSingleLine());
        Assertions.assertNull((Object)this.layout.getGlobalSeparator());
    }

    @Test
    void testInitCopy() {
        this.fillLayout();
        PropertiesConfigurationLayout l2 = new PropertiesConfigurationLayout(this.layout);
        Assertions.assertEquals((Object)l2.getKeys(), (Object)this.layout.getKeys());
        Assertions.assertEquals((Object)this.layout.getHeaderComment(), (Object)l2.getHeaderComment());
        Assertions.assertEquals((Object)this.layout.getFooterComment(), (Object)l2.getFooterComment());
    }

    @Test
    void testInitCopyModify() {
        this.fillLayout();
        PropertiesConfigurationLayout l2 = new PropertiesConfigurationLayout(this.layout);
        Assertions.assertEquals((Object)this.layout.getComment(TEST_KEY), (Object)l2.getComment(TEST_KEY));
        this.layout.setComment(TEST_KEY, "A new comment");
        Assertions.assertEquals((Object)TEST_COMMENT, (Object)l2.getCanonicalComment(TEST_KEY, false));
        l2.setBlankLinesBefore(TEST_KEY, l2.getBlankLinesBefore(TEST_KEY) + 1);
        Assertions.assertNotEquals((int)this.layout.getBlankLinesBefore(TEST_KEY), (int)l2.getBlankLinesBefore(TEST_KEY));
    }

    @Test
    void testInitNull() {
        this.layout = new PropertiesConfigurationLayout(null);
        Assertions.assertTrue((boolean)this.layout.getKeys().isEmpty());
    }

    @Test
    void testIsSingleLine() throws ConfigurationException {
        this.builder.addProperty(TEST_KEY, "myPropertyValue,myPropertyValue2");
        this.layout.load((PropertiesConfiguration)this.config, this.builder.getReader());
        Assertions.assertTrue((boolean)this.layout.isSingleLine(TEST_KEY));
        Assertions.assertEquals((int)2, (int)this.config.getList(TEST_KEY).size());
    }

    @Test
    void testIsSingleLineMulti() throws ConfigurationException {
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.builder.addProperty("anotherProp", "a value");
        this.builder.addProperty(TEST_KEY, "myPropertyValue2");
        this.layout.load((PropertiesConfiguration)this.config, this.builder.getReader());
        Assertions.assertFalse((boolean)this.layout.isSingleLine(TEST_KEY));
        Assertions.assertEquals((int)2, (int)this.config.getList(TEST_KEY).size());
    }

    @Test
    void testLineWithBlank() throws ConfigurationException {
        this.builder.addComment(TEST_COMMENT);
        this.builder.addLine(" ");
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.load((PropertiesConfiguration)this.config, this.builder.getReader());
        Assertions.assertEquals((Object)"A comment for my test property\n ", (Object)this.layout.getCanonicalComment(TEST_KEY, false));
    }

    @Test
    void testReadAndWrite() throws ConfigurationException {
        this.builder.addComment("This is my test properties file,");
        this.builder.addComment("which contains a header comment.");
        this.builder.addComment(null);
        this.builder.addComment(null);
        this.builder.addComment(TEST_COMMENT);
        this.builder.addProperty(TEST_KEY, TEST_COMMENT);
        this.builder.addComment(null);
        this.builder.addComment(null);
        this.builder.addComment("Another comment");
        this.builder.addProperty("property", "and a value");
        this.layout.load((PropertiesConfiguration)this.config, this.builder.getReader());
        this.checkLayoutString(this.builder.toString());
    }

    @Test
    void testReadSimple() throws ConfigurationException {
        this.builder.addComment(TEST_COMMENT);
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.load((PropertiesConfiguration)this.config, this.builder.getReader());
        Assertions.assertNull((Object)this.layout.getHeaderComment());
        Assertions.assertEquals((int)1, (int)this.layout.getKeys().size());
        Assertions.assertTrue((boolean)this.layout.getKeys().contains(TEST_KEY));
        Assertions.assertEquals((Object)TEST_COMMENT, (Object)this.layout.getCanonicalComment(TEST_KEY, false));
        Assertions.assertEquals((int)0, (int)this.layout.getBlankLinesBefore(TEST_KEY));
        Assertions.assertTrue((boolean)this.layout.isSingleLine(TEST_KEY));
        Assertions.assertEquals((Object)TEST_VALUE, (Object)this.config.getString(TEST_KEY));
    }

    @Test
    void testRecursiveLoadCall() throws ConfigurationException {
        PropertiesBuilder b = new PropertiesBuilder();
        b.addComment("A nested header comment.");
        b.addComment("With multiple lines");
        b.addComment(null);
        b.addComment("Second comment");
        b.addProperty(TEST_KEY, TEST_VALUE);
        b.addProperty("myProperty2", "myPropertyValue2");
        this.config.builder = b;
        this.builder.addComment("Header comment");
        this.builder.addComment(null);
        this.builder.addComment(TEST_COMMENT);
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.builder.addComment("Include file");
        this.builder.addProperty(PropertiesConfiguration.getInclude(), "test");
        this.layout.load((PropertiesConfiguration)this.config, this.builder.getReader());
        Assertions.assertEquals((Object)"Header comment", (Object)this.layout.getCanonicalHeaderComment(false));
        Assertions.assertFalse((boolean)this.layout.getKeys().contains(PropertiesConfiguration.getInclude()));
        Assertions.assertEquals((Object)"A comment for my test property\nA nested header comment.\nWith multiple lines\n\nSecond comment", (Object)this.layout.getCanonicalComment(TEST_KEY, false));
    }

    @Test
    void testSave() throws ConfigurationException {
        this.config.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.setComment(TEST_KEY, TEST_COMMENT);
        this.config.addProperty(TEST_KEY, "myPropertyValue2");
        this.config.addProperty("AnotherProperty", "AnotherValue");
        this.config.addProperty("AnotherProperty", "3rdValue");
        this.layout.setComment("AnotherProperty", "AnotherComment");
        this.layout.setBlankLinesBefore("AnotherProperty", 2);
        this.layout.setSingleLine("AnotherProperty", true);
        this.layout.setHeaderComment("A header comment\nfor my properties");
        this.checkLayoutString("# A header comment" + CR + "# for my properties" + CR + CR + "# " + TEST_COMMENT + CR + TEST_KEY + " = " + TEST_VALUE + CR + TEST_KEY + " = " + TEST_VALUE + "2" + CR + CR + CR + "# AnotherComment" + CR + "AnotherProperty = AnotherValue,3rdValue" + CR);
    }

    @Test
    void testSaveCommentForUnexistingProperty() throws ConfigurationException {
        this.fillLayout();
        this.layout.setComment("NonExistingKey", "NonExistingComment");
        String output = this.getLayoutString();
        Assertions.assertFalse((boolean)output.contains("NonExistingKey"));
        Assertions.assertFalse((boolean)output.contains("NonExistingComment"));
    }

    @Test
    void testSaveEmptyLayout() throws ConfigurationException {
        this.checkLayoutString("");
    }

    @Test
    void testSaveForceSingleLine() throws ConfigurationException {
        this.config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(';'));
        this.config.addProperty(TEST_KEY, TEST_VALUE);
        this.config.addProperty(TEST_KEY, "myPropertyValue2");
        this.config.addProperty("AnotherProperty", "value1;value2;value3");
        this.layout.setComment(TEST_KEY, TEST_COMMENT);
        this.layout.setForceSingleLine(true);
        this.checkLayoutString("# A comment for my test property" + CR + TEST_KEY + " = " + TEST_VALUE + ';' + TEST_VALUE + "2" + CR + "AnotherProperty = value1;value2;value3" + CR);
    }

    @Test
    void testSetGlobalSeparator() throws ConfigurationException {
        String sep = "=";
        this.config.addProperty(TEST_KEY, TEST_VALUE);
        this.config.addProperty("key2", "value2");
        this.layout.setSeparator(TEST_KEY, " : ");
        this.layout.setGlobalSeparator("=");
        this.checkLayoutString("myProperty=myPropertyValue" + CR + "key2" + "=" + "value2" + CR);
    }

    @Test
    void testSetLineSeparator() throws ConfigurationException {
        String lf = CR + CR;
        this.config.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.setBlankLinesBefore(TEST_KEY, 2);
        this.layout.setComment(TEST_KEY, TEST_COMMENT);
        this.layout.setHeaderComment("Header comment");
        this.layout.setLineSeparator(lf);
        this.checkLayoutString("# Header comment" + lf + lf + lf + "# " + TEST_COMMENT + lf + TEST_KEY + " = " + TEST_VALUE + lf);
    }

    @Test
    void testSetLineSeparatorInComments() throws ConfigurationException {
        String lf = "<-\n";
        this.config.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.setComment(TEST_KEY, "A comment for my test property\nMore comment");
        this.layout.setHeaderComment("Header\ncomment");
        this.layout.setLineSeparator("<-\n");
        this.checkLayoutString("# Header<-\n# comment<-\n<-\n# A comment for my test property<-\n# More comment<-\nmyProperty = myPropertyValue<-\n");
    }

    @Test
    void testSetNullComment() {
        this.fillLayout();
        this.layout.setComment(TEST_KEY, null);
        Assertions.assertNull((Object)this.layout.getComment(TEST_KEY));
    }

    @Test
    void testSetSeparator() throws ConfigurationException {
        this.config.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.setSeparator(TEST_KEY, ":");
        this.checkLayoutString("myProperty:myPropertyValue" + CR);
    }

    @Test
    void testTrimComment() {
        Assertions.assertEquals((Object)("This is a comment" + CR + "that spans multiple" + CR + "lines in a" + CR + " complex way."), (Object)PropertiesConfigurationLayout.trimComment((String)("   # This is a comment" + CR + "that spans multiple" + CR + "!lines in a" + CR + " complex way."), (boolean)false));
    }

    @Test
    void testTrimCommentFalse() {
        Assertions.assertEquals((Object)("# Comment with" + CR + " ! some mixed " + CR + "#comment" + CR + "# lines"), (Object)PropertiesConfigurationLayout.trimComment((String)("Comment with" + CR + " ! some mixed " + CR + "#comment" + CR + "lines"), (boolean)true));
    }

    @Test
    void testTrimCommentTrainlingCR() {
        Assertions.assertEquals((Object)("Comment with" + CR + "trailing CR" + CR), (Object)PropertiesConfigurationLayout.trimComment((String)("Comment with" + CR + "! trailing CR" + CR), (boolean)false));
    }

    static class PropertiesBuilder {
        private final StringBuilder buf = new StringBuilder();
        private int commentCounter;

        PropertiesBuilder() {
        }

        public void addComment(String s) {
            if (s != null) {
                if (this.commentCounter % 2 == 0) {
                    this.buf.append("# ");
                } else {
                    this.buf.append("! ");
                }
                this.buf.append(s);
                ++this.commentCounter;
            }
            this.buf.append(CR);
        }

        public void addLine(String s) {
            this.buf.append(s).append(CR);
        }

        public void addProperty(String key, String value) {
            this.buf.append(key).append(" = ").append(value).append(CR);
        }

        public Reader getReader() {
            return new StringReader(this.buf.toString());
        }

        public String toString() {
            return this.buf.toString();
        }
    }

    static class LayoutTestConfiguration
    extends PropertiesConfiguration {
        private PropertiesBuilder builder;

        LayoutTestConfiguration() {
        }

        boolean propertyLoaded(String key, String value, Deque<URL> seenStack) throws ConfigurationException {
            if (this.builder == null) {
                return super.propertyLoaded(key, value, seenStack);
            }
            if (PropertiesConfiguration.getInclude().equals(key)) {
                this.getLayout().load((PropertiesConfiguration)this, this.builder.getReader());
                return false;
            }
            return true;
        }
    }
}

