/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.osgi;

import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.configuration.runtime.DataDomainProvider;
import org.apache.cayenne.di.ClassLoaderManager;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;

public class OsgiDataDomainProvider
extends DataDomainProvider {
    private ClassLoaderManager classLoaderManager;

    public OsgiDataDomainProvider(@Inject ClassLoaderManager classLoaderManager) {
        this.classLoaderManager = classLoaderManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataDomain get() throws ConfigurationException {
        Thread thread = Thread.currentThread();
        ClassLoader activeCl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.classLoaderManager.getClassLoader("com/"));
            DataDomain domain = super.get();
            EntityResolver entityResolver = domain.getEntityResolver();
            for (ObjEntity e : entityResolver.getObjEntities()) {
                entityResolver.getClassDescriptor(e.getName()).getProperty("__dummy__");
                entityResolver.getCallbackRegistry();
            }
            entityResolver.getCallbackRegistry();
            DataDomain dataDomain = domain;
            return dataDomain;
        }
        finally {
            thread.setContextClassLoader(activeCl);
        }
    }
}

