/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import org.apache.cayenne.configuration.BaseConfigurationNodeVisitor;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.project.ConfigurationNodeParentGetter;

public class DefaultConfigurationNodeParentGetter
implements ConfigurationNodeParentGetter {
    private ConfigurationNodeVisitor<ConfigurationNode> parentGetter = new ParentGetter();

    @Override
    public ConfigurationNode getParent(ConfigurationNode node) {
        return (ConfigurationNode)node.acceptVisitor(this.parentGetter);
    }

    class ParentGetter
    extends BaseConfigurationNodeVisitor<ConfigurationNode> {
        ParentGetter() {
        }

        public ConfigurationNode visitDataMap(DataMap dataMap) {
            return dataMap.getDataChannelDescriptor();
        }

        public ConfigurationNode visitDataNodeDescriptor(DataNodeDescriptor nodeDescriptor) {
            return nodeDescriptor.getDataChannelDescriptor();
        }

        public ConfigurationNode visitDbAttribute(DbAttribute attribute) {
            return (ConfigurationNode)attribute.getParent();
        }

        public ConfigurationNode visitDbEntity(DbEntity entity) {
            return entity.getDataMap();
        }

        public ConfigurationNode visitDbRelationship(DbRelationship relationship) {
            return (ConfigurationNode)relationship.getParent();
        }

        public ConfigurationNode visitEmbeddable(Embeddable embeddable) {
            return embeddable.getDataMap();
        }

        public ConfigurationNode visitEmbeddableAttribute(EmbeddableAttribute attribute) {
            return attribute.getEmbeddable();
        }

        public ConfigurationNode visitObjAttribute(ObjAttribute attribute) {
            return (ConfigurationNode)attribute.getParent();
        }

        public ConfigurationNode visitObjEntity(ObjEntity entity) {
            return (ConfigurationNode)entity.getParent();
        }

        public ConfigurationNode visitObjRelationship(ObjRelationship relationship) {
            return (ConfigurationNode)relationship.getParent();
        }

        public ConfigurationNode visitProcedure(Procedure procedure) {
            return (ConfigurationNode)procedure.getParent();
        }

        public ConfigurationNode visitProcedureParameter(ProcedureParameter parameter) {
            return (ConfigurationNode)parameter.getParent();
        }

        public ConfigurationNode visitQuery(QueryDescriptor query) {
            return query.getDataMap();
        }
    }
}

