/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tx;

import java.sql.Connection;
import java.util.function.Supplier;
import org.apache.cayenne.tx.TransactionPropagation;

public class TransactionDescriptor {
    public static final int ISOLATION_DEFAULT = -1;
    private static final TransactionDescriptor DEFAULT_DESCRIPTOR = TransactionDescriptor.builder().propagation(TransactionPropagation.NESTED).isolation(-1).build();
    private int isolation;
    private TransactionPropagation propagation;
    private Supplier<Connection> connectionSupplier;

    protected TransactionDescriptor() {
    }

    public int getIsolation() {
        return this.isolation;
    }

    public TransactionPropagation getPropagation() {
        return this.propagation;
    }

    public Supplier<Connection> getConnectionSupplier() {
        return this.connectionSupplier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TransactionDescriptor defaultDescriptor() {
        return DEFAULT_DESCRIPTOR;
    }

    public static class Builder {
        private final TransactionDescriptor transactionDescriptor = new TransactionDescriptor();

        private Builder() {
        }

        public Builder isolation(int isolation) {
            this.transactionDescriptor.isolation = isolation;
            return this;
        }

        public Builder connection(Connection connection) {
            this.transactionDescriptor.connectionSupplier = () -> connection;
            return this;
        }

        public Builder connectionSupplier(Supplier<Connection> connectionSupplier) {
            this.transactionDescriptor.connectionSupplier = connectionSupplier;
            return this;
        }

        public Builder propagation(TransactionPropagation propagation) {
            this.transactionDescriptor.propagation = propagation;
            return this;
        }

        public TransactionDescriptor build() {
            return this.transactionDescriptor;
        }
    }
}

