/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tx;

import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.tx.CayenneTransaction;
import org.apache.cayenne.tx.ExternalTransaction;
import org.apache.cayenne.tx.Transaction;
import org.apache.cayenne.tx.TransactionDescriptor;
import org.apache.cayenne.tx.TransactionFactory;

public class DefaultTransactionFactory
implements TransactionFactory {
    protected boolean externalTransactions;
    protected JdbcEventLogger jdbcEventLogger;

    public DefaultTransactionFactory(@Inject RuntimeProperties properties, @Inject JdbcEventLogger jdbcEventLogger) {
        this.externalTransactions = properties.getBoolean("cayenne.external_tx", false);
        this.jdbcEventLogger = jdbcEventLogger;
    }

    @Override
    public Transaction createTransaction() {
        return this.createTransaction(TransactionDescriptor.defaultDescriptor());
    }

    @Override
    public Transaction createTransaction(TransactionDescriptor descriptor) {
        return this.externalTransactions ? new ExternalTransaction(this.jdbcEventLogger, descriptor) : new CayenneTransaction(this.jdbcEventLogger, descriptor);
    }
}

