/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.translator.select.DbIdPathTranslationResult;
import org.apache.cayenne.access.translator.select.DbPathProcessor;
import org.apache.cayenne.access.translator.select.ObjPathProcessor;
import org.apache.cayenne.access.translator.select.PathTranslationResult;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.map.ObjEntity;

class PathTranslator {
    private final Map<CayennePath, PathTranslationResult> objResultCache = new ConcurrentHashMap<CayennePath, PathTranslationResult>();
    private final Map<CayennePath, PathTranslationResult> dbResultCache = new ConcurrentHashMap<CayennePath, PathTranslationResult>();
    private final TranslatorContext context;

    PathTranslator(TranslatorContext context) {
        this.context = context;
    }

    PathTranslationResult translatePath(ObjEntity entity, CayennePath path, CayennePath parentPath) {
        CayennePath key = parentPath == null ? path.dot(entity.getName()) : parentPath.dot(path).dot(entity.getName());
        return this.objResultCache.computeIfAbsent(key, k -> new ObjPathProcessor(this.context, entity, parentPath).process(path));
    }

    PathTranslationResult translatePath(ObjEntity entity, CayennePath path) {
        return this.translatePath(entity, path, null);
    }

    PathTranslationResult translatePath(DbEntity entity, CayennePath path, CayennePath parentPath, boolean flattenedPath) {
        CayennePath key = parentPath == null ? path.dot(entity.getName()) : parentPath.dot(path).dot(entity.getName());
        return this.dbResultCache.computeIfAbsent(key, k -> new DbPathProcessor(this.context, entity, parentPath, flattenedPath).process(path));
    }

    PathTranslationResult translatePath(DbEntity entity, CayennePath path, CayennePath parentPath) {
        return this.translatePath(entity, path, parentPath, false);
    }

    PathTranslationResult translatePath(DbEntity entity, CayennePath path) {
        return this.translatePath(entity, path, null);
    }

    PathTranslationResult translateIdPath(ObjEntity entity, CayennePath path) {
        CayennePath objPathPart = path.parent();
        String pkName = path.last().value();
        if (objPathPart.isEmpty()) {
            if (pkName.isEmpty()) {
                throw new CayenneRuntimeException("Can't translate empty dbid path", new Object[0]);
            }
            DbAttribute pk = (DbAttribute)entity.getDbEntity().getAttribute(pkName);
            if (pk == null) {
                throw new CayenneRuntimeException("Can't translate dbid path '%s', no such pk", path);
            }
            return new DbIdPathTranslationResult(CayennePath.EMPTY_PATH, pk);
        }
        PathTranslationResult dbIdResult = this.translatePath(entity, objPathPart);
        DbRelationship relationship = dbIdResult.getDbRelationship().orElseThrow(() -> new CayenneRuntimeException("Can't translate dbid path '%s', can't resolve relationship %s", path, objPathPart));
        JoinType joinType = objPathPart.last().isOuterJoin() ? JoinType.LEFT_OUTER : JoinType.INNER;
        this.context.getTableTree().addJoinTable(dbIdResult.getFinalPath(), relationship, joinType);
        DbAttribute pk = (DbAttribute)relationship.getTargetEntity().getAttribute(pkName);
        if (pk == null) {
            throw new CayenneRuntimeException("Can't translate dbid path '%s', no such pk", path);
        }
        return new DbIdPathTranslationResult(dbIdResult.getFinalPath(), pk);
    }
}

