/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.extension.info;

import java.util.Map;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.project.extension.BaseSaverDelegate;
import org.apache.cayenne.project.extension.info.ObjectInfo;
import org.apache.cayenne.util.Util;

class InfoSaverDelegate
extends BaseSaverDelegate {
    private DataChannelMetaData metaData;

    InfoSaverDelegate(DataChannelMetaData metaData) {
        this.metaData = metaData;
    }

    private Void printComment(ConfigurationNode entity) {
        ObjectInfo info = this.metaData.get(entity, ObjectInfo.class);
        if (info == null) {
            return null;
        }
        for (Map.Entry<String, String> entry : info.getSortedValues().entrySet()) {
            if (Util.isEmptyString(entry.getValue())) continue;
            this.encoder.start("info:property").attribute("xmlns:info", "http://cayenne.apache.org/schema/11/info").attribute("name", entry.getKey()).attribute("value", entry.getValue()).end();
        }
        return null;
    }

    @Override
    public Void visitDataMap(DataMap dataMap) {
        return this.printComment(dataMap);
    }

    @Override
    public Void visitObjEntity(ObjEntity entity) {
        return this.printComment(entity);
    }

    @Override
    public Void visitDbEntity(DbEntity entity) {
        return this.printComment(entity);
    }

    @Override
    public Void visitEmbeddable(Embeddable embeddable) {
        return this.printComment(embeddable);
    }

    @Override
    public Void visitEmbeddableAttribute(EmbeddableAttribute attribute) {
        return this.printComment(attribute);
    }

    @Override
    public Void visitObjAttribute(ObjAttribute attribute) {
        return this.printComment(attribute);
    }

    @Override
    public Void visitDbAttribute(DbAttribute attribute) {
        return this.printComment(attribute);
    }

    @Override
    public Void visitObjRelationship(ObjRelationship relationship) {
        return this.printComment(relationship);
    }

    @Override
    public Void visitDbRelationship(DbRelationship relationship) {
        return this.printComment(relationship);
    }

    @Override
    public Void visitProcedure(Procedure procedure) {
        return this.printComment(procedure);
    }

    @Override
    public Void visitProcedureParameter(ProcedureParameter parameter) {
        return this.printComment(parameter);
    }

    @Override
    public Void visitQuery(QueryDescriptor query) {
        return this.printComment(query);
    }
}

