/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util.state;

import java.util.ArrayList;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.util.state.EntityDisplayEventType;

class AttributeDisplayEventType
extends EntityDisplayEventType {
    AttributeDisplayEventType(ProjectController controller) {
        super(controller);
    }

    @Override
    public void fireLastDisplayEvent() {
        DataChannelDescriptor dataChannel = (DataChannelDescriptor)this.controller.getProject().getRootNode();
        if (!dataChannel.getName().equals(this.preferences.getDomain())) {
            return;
        }
        DataNodeDescriptor dataNode = dataChannel.getNodeDescriptor(this.preferences.getNode());
        DataMap dataMap = dataChannel.getDataMap(this.preferences.getDataMap());
        if (dataMap == null) {
            return;
        }
        Entity<?, ?, ?> entity = this.getLastEntity(dataMap);
        if (entity == null) {
            return;
        }
        Attribute<?, ?, ?>[] attributes = this.getLastEntityAttributes(entity);
        EntityDisplayEvent entityDisplayEvent = new EntityDisplayEvent(this, entity, dataMap, dataNode, dataChannel);
        AttributeDisplayEvent attributeDisplayEvent = new AttributeDisplayEvent((Object)this, attributes, entity, dataMap, dataChannel);
        if (entity instanceof ObjEntity) {
            this.controller.fireObjEntityDisplayEvent(entityDisplayEvent);
            this.controller.fireObjAttributeDisplayEvent(attributeDisplayEvent);
        } else if (entity instanceof DbEntity) {
            this.controller.fireDbEntityDisplayEvent(entityDisplayEvent);
            this.controller.fireDbAttributeDisplayEvent(attributeDisplayEvent);
        }
    }

    @Override
    public void saveLastDisplayEvent() {
        this.preferences.setEvent(AttributeDisplayEvent.class.getSimpleName());
        this.preferences.setDomain(this.controller.getCurrentDataChanel().getName());
        this.preferences.setNode(this.controller.getCurrentDataNode() != null ? this.controller.getCurrentDataNode().getName() : "");
        this.preferences.setDataMap(this.controller.getCurrentDataMap().getName());
        if (this.controller.getCurrentObjEntity() != null) {
            this.preferences.setObjEntity(this.controller.getCurrentObjEntity().getName());
            this.preferences.setObjAttrs(this.parseToString(this.controller.getCurrentObjAttributes()));
            this.preferences.setDbEntity(null);
        } else if (this.controller.getCurrentDbEntity() != null) {
            this.preferences.setDbEntity(this.controller.getCurrentDbEntity().getName());
            this.preferences.setDbAttrs(this.parseToString(this.controller.getCurrentDbAttributes()));
            this.preferences.setObjEntity(null);
        }
    }

    protected Attribute<?, ?, ?>[] getLastEntityAttributes(Entity<?, ?, ?> entity) {
        ArrayList attributeList = new ArrayList();
        String attrs = entity instanceof ObjEntity ? this.preferences.getObjAttrs() : this.preferences.getDbAttrs();
        for (String attrName : attrs.split(",")) {
            Object attr = entity.getAttribute(attrName);
            if (attr == null) continue;
            attributeList.add(attr);
        }
        return attributeList.toArray(new Attribute[0]);
    }
}

