/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.RemoveAttributeAction;
import org.apache.cayenne.modeler.undo.BaseRemovePropertyUndoableEdit;
import org.apache.cayenne.util.XMLSerializable;

public class RemoveAttributeUndoableEdit
extends BaseRemovePropertyUndoableEdit {
    private DbAttribute[] dbAttributes;
    private ObjAttribute[] objAttributes;
    private EmbeddableAttribute[] embeddableAttrs;

    public RemoveAttributeUndoableEdit(Embeddable embeddable, EmbeddableAttribute[] embeddableAttributes) {
        this.embeddable = embeddable;
        this.embeddableAttrs = embeddableAttributes;
    }

    public RemoveAttributeUndoableEdit(ObjEntity entity, ObjAttribute[] objAttributes) {
        this.objEntity = entity;
        this.objAttributes = objAttributes;
    }

    public RemoveAttributeUndoableEdit(DbEntity entity, DbAttribute[] dbAttributes) {
        this.dbEntity = entity;
        this.dbAttributes = dbAttributes;
    }

    @Override
    public void redo() throws CannotRedoException {
        RemoveAttributeAction action = this.actionManager.getAction(RemoveAttributeAction.class);
        if (this.objEntity != null) {
            action.removeObjAttributes(this.objEntity, this.objAttributes);
            this.focusObjEntity();
        }
        if (this.dbEntity != null) {
            action.removeDbAttributes(this.dbEntity.getDataMap(), this.dbEntity, this.dbAttributes);
            this.focusDBEntity();
        }
        if (this.embeddable != null) {
            action.removeEmbeddableAttributes(this.embeddable, this.embeddableAttrs);
            this.focusEmbeddable();
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        CreateAttributeAction action = this.actionManager.getAction(CreateAttributeAction.class);
        if (this.objEntity != null) {
            for (XMLSerializable xMLSerializable : this.objAttributes) {
                action.createObjAttribute(this.objEntity.getDataMap(), this.objEntity, (ObjAttribute)xMLSerializable);
            }
            this.focusObjEntity();
        }
        if (this.dbEntity != null) {
            for (XMLSerializable xMLSerializable : this.dbAttributes) {
                action.createDbAttribute(this.dbEntity.getDataMap(), this.dbEntity, (DbAttribute)xMLSerializable);
            }
            this.focusDBEntity();
        }
        if (this.embeddable != null) {
            for (XMLSerializable xMLSerializable : this.embeddableAttrs) {
                action.createEmbAttribute(this.embeddable, (EmbeddableAttribute)xMLSerializable);
            }
            this.focusEmbeddable();
        }
    }

    @Override
    public String getPresentationName() {
        if (this.objEntity != null) {
            return this.objAttributes.length > 1 ? "Remove ObjAttributes" : "Remove ObjAttribute";
        }
        if (this.dbEntity != null) {
            return this.dbAttributes.length > 1 ? "Remove DbAttributes" : "Remove DbAttribute";
        }
        if (this.embeddableAttrs != null) {
            return this.embeddableAttrs.length > 1 ? "Remove Embeddable Attributes" : "Remove Embeddable Attribute";
        }
        return super.getPresentationName();
    }
}

