/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class RelationshipUndoableEdit
extends CayenneUndoableEdit {
    private static final long serialVersionUID = -1864303176024098961L;
    private Relationship<?, ?, ?> relationship;
    private Relationship<?, ?, ?> prevRelationship;
    private ProjectController projectController = Application.getInstance().getFrameController().getProjectController();
    private boolean useDb;

    public RelationshipUndoableEdit(Relationship<?, ?, ?> relationship) {
        this.relationship = relationship;
        this.useDb = relationship instanceof DbRelationship;
        this.prevRelationship = this.copyRelationship(relationship);
    }

    @Override
    public void redo() throws CannotRedoException {
        this.fireRelationshipEvent(this.relationship, this.prevRelationship);
    }

    @Override
    public void undo() throws CannotUndoException {
        this.fireRelationshipEvent(this.prevRelationship, this.relationship);
    }

    private void fireRelationshipEvent(Relationship<?, ?, ?> relToFire, Relationship<?, ?, ?> currRel) {
        if (this.useDb) {
            this.fireDbRelationshipEvent((DbRelationship)relToFire, (DbRelationship)currRel);
        } else {
            this.fireObjRelationshipEvent((ObjRelationship)relToFire, (ObjRelationship)currRel);
        }
    }

    private void fireDbRelationshipEvent(DbRelationship relToFire, DbRelationship currRel) {
        DbEntity dbEntity = (DbEntity)currRel.getSourceEntity();
        dbEntity.removeRelationship(currRel.getName());
        dbEntity.addRelationship(relToFire);
        this.projectController.fireDbRelationshipEvent(new RelationshipEvent((Object)this, (Relationship<?, ?, ?>)relToFire, (Entity<?, ?, ?>)relToFire.getSourceEntity(), 2));
    }

    private void fireObjRelationshipEvent(ObjRelationship relToFire, ObjRelationship currRel) {
        ObjEntity objEntity = currRel.getSourceEntity();
        objEntity.removeRelationship(currRel.getName());
        objEntity.addRelationship(relToFire);
        this.projectController.fireObjRelationshipEvent(new RelationshipEvent((Object)this, relToFire, relToFire.getSourceEntity(), 2));
    }

    @Override
    public String getRedoPresentationName() {
        return "Redo Edit relationship";
    }

    @Override
    public String getUndoPresentationName() {
        return "Undo Edit relationship";
    }

    private Relationship<?, ?, ?> copyRelationship(Relationship<?, ?, ?> relationship) {
        return this.useDb ? this.getDbRelationship((DbRelationship)relationship) : this.getObjRelationship((ObjRelationship)relationship);
    }

    private DbRelationship getDbRelationship(DbRelationship dbRelationship) {
        DbRelationship rel = new DbRelationship();
        rel.setName(dbRelationship.getName());
        rel.setToDependentPK(dbRelationship.isToDependentPK());
        rel.setToMany(dbRelationship.isToMany());
        rel.setTargetEntityName(dbRelationship.getTargetEntityName());
        rel.setSourceEntity((DbEntity)dbRelationship.getSourceEntity());
        rel.setJoins(rel.getJoins());
        return rel;
    }

    private ObjRelationship getObjRelationship(ObjRelationship objRelationship) {
        ObjRelationship rel = new ObjRelationship();
        rel.setName(objRelationship.getName());
        rel.setTargetEntityName(objRelationship.getTargetEntityName());
        rel.setSourceEntity(objRelationship.getSourceEntity());
        rel.setDeleteRule(objRelationship.getDeleteRule());
        rel.setUsedForLocking(objRelationship.isUsedForLocking());
        rel.setDbRelationshipPath(objRelationship.getDbRelationshipPath());
        rel.setCollectionType(objRelationship.getCollectionType());
        rel.setMapKey(objRelationship.getMapKey());
        return rel;
    }
}

