/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JOptionPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.dbsync.naming.ObjectNameGenerator;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.DeleteRule;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ClassLoadingService;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.DbRelationshipDialog;
import org.apache.cayenne.modeler.dialog.objentity.ObjRelationshipInfoView;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;
import org.apache.cayenne.modeler.undo.CreateRelationshipUndoableEdit;
import org.apache.cayenne.modeler.undo.RelationshipUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.modeler.util.EntityTreeModel;
import org.apache.cayenne.modeler.util.EntityTreeRelationshipFilter;
import org.apache.cayenne.modeler.util.MultiColumnBrowser;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.project.extension.info.ObjectInfo;
import org.apache.cayenne.util.DeleteRuleUpdater;
import org.apache.cayenne.util.Util;

public class ObjRelationshipInfo
extends CayenneController
implements TreeSelectionListener {
    private static final String COLLECTION_TYPE_MAP = "java.util.Map";
    private static final String COLLECTION_TYPE_SET = "java.util.Set";
    private static final String COLLECTION_TYPE_COLLECTION = "java.util.Collection";
    private static final String DEFAULT_MAP_KEY = "ID (default)";
    protected ObjRelationship relationship;
    private List<DbRelationship> dbRelationships;
    private List<DbRelationship> savedDbRelationships;
    private ObjEntity objectTarget;
    private List<ObjEntity> objectTargets;
    private List<String> targetCollections;
    private List<String> mapKeys;
    private String targetCollection;
    private String mapKey;
    private ObjRelationshipInfoView view = new ObjRelationshipInfoView();
    private String currentPath;
    private ProjectController mediator;
    private RelationshipUndoableEdit undo;
    private boolean isCreate = false;

    public void startupAction() {
        this.view.pack();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
    }

    public ObjRelationshipInfo(ProjectController mediator) {
        super(mediator);
        this.mediator = mediator;
        this.getPathBrowser().addTreeSelectionListener(this);
        this.targetCollections = new ArrayList<String>(4);
        this.targetCollections.add(COLLECTION_TYPE_COLLECTION);
        this.targetCollections.add("java.util.List");
        this.targetCollections.add(COLLECTION_TYPE_MAP);
        this.targetCollections.add(COLLECTION_TYPE_SET);
        for (String s : this.targetCollections) {
            this.view.getCollectionTypeCombo().addItem(s);
        }
        this.mapKeys = new ArrayList<String>();
    }

    public ObjRelationshipInfo createRelationship(ObjEntity objEntity) {
        ObjRelationship rel = new ObjRelationship();
        rel.setName(NameBuilder.builder(rel, objEntity).name());
        rel.setSourceEntity(objEntity);
        DeleteRuleUpdater.updateObjRelationship(rel);
        this.isCreate = true;
        return this.modifyRelationship(rel);
    }

    public ObjRelationshipInfo modifyRelationship(ObjRelationship rel) {
        this.relationship = rel;
        this.undo = new RelationshipUndoableEdit(rel);
        this.validateCanMap();
        this.initFromModel();
        this.initController();
        return this;
    }

    private void initController() {
        this.view.getCancelButton().addActionListener(e -> this.view.dispose());
        this.view.getSaveButton().addActionListener(e -> this.saveMapping());
        this.view.getNewRelButton().addActionListener(e -> this.createRelationship());
        this.view.getCollectionTypeCombo().addActionListener(e -> this.setCollectionType());
        this.view.getMapKeysCombo().addActionListener(e -> this.setMapKey());
        this.view.getTargetCombo().addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Object targetName = e.getItem();
                for (ObjEntity target : this.objectTargets) {
                    if (!Objects.equals(target.getName(), targetName)) continue;
                    this.setObjectTarget(target);
                    return;
                }
            }
        });
        this.view.getDeleteRule().addActionListener(e -> this.setDeleteRule());
        this.view.getUsedForLocking().addActionListener(e -> this.setUsedForLocking());
        this.view.getComment().addActionListener(e -> this.setComment());
    }

    private void initFromModel() {
        this.view.getSourceEntityLabel().setText(this.relationship.getSourceEntity().getName());
        this.view.getRelationshipName().setText(this.relationship.getName());
        this.mapKey = this.relationship.getMapKey();
        this.targetCollection = this.relationship.getCollectionType();
        if (this.targetCollection == null) {
            this.targetCollection = "java.util.List";
        }
        this.objectTarget = this.relationship.getTargetEntity();
        if (this.objectTarget != null) {
            this.updateTargetCombo(this.objectTarget.getDbEntity());
            this.view.getTargetCombo().setSelectedItem(this.objectTarget.getName());
        }
        this.view.getUsedForLocking().setSelected(this.relationship.isUsedForLocking());
        this.view.getDeleteRule().setSelectedItem(DeleteRule.deleteRuleName(this.relationship.getDeleteRule()));
        this.view.getComment().setText(ObjectInfo.getFromMetaData(this.mediator.getApplication().getMetaData(), this.relationship, "comment"));
        this.setSemantics();
        this.dbRelationships = new ArrayList<DbRelationship>(this.relationship.getDbRelationships());
        this.savedDbRelationships = this.dbRelationships;
        this.initMapKeys();
        this.updateCollectionChoosers();
        this.connectEnds();
        if (this.view.getPathBrowser().getModel() == null) {
            EntityTreeModel treeModel = new EntityTreeModel(this.getStartEntity());
            treeModel.setFilter(new EntityTreeRelationshipFilter());
            this.view.getPathBrowser().setModel(treeModel);
            this.setSelectionPath(this.getSavedDbRelationships());
        }
        this.view.getSaveButton().setEnabled(!this.dbRelationships.isEmpty());
    }

    private void setSelectionPath(List<DbRelationship> rels) {
        Object[] path = new Object[rels.size() + 1];
        path[0] = this.getStartEntity();
        System.arraycopy(rels.toArray(), 0, path, 1, rels.size());
        this.view.getPathBrowser().setSelectionPath(new TreePath(path));
    }

    private void setCollectionType() {
        this.setTargetCollection((String)this.view.getCollectionTypeCombo().getSelectedItem());
        if (COLLECTION_TYPE_MAP.equals(this.targetCollection)) {
            this.view.getMapKeysLabel().setEnabled(true);
            this.view.getMapKeysCombo().setEnabled(true);
            this.setMapKey();
        } else {
            this.view.getMapKeysLabel().setEnabled(false);
            this.view.getMapKeysCombo().setEnabled(false);
        }
    }

    public void setMapKey() {
        this.setMapKey((String)this.view.getMapKeysCombo().getSelectedItem());
    }

    @Override
    public Component getView() {
        return this.view;
    }

    protected void revertPath() {
        this.setSelectionPath(this.getSavedDbRelationships());
        this.setDbRelationships(this.getSavedDbRelationships());
    }

    protected void updateCollectionChoosers() {
        boolean collectionTypeEnabled = this.isToMany();
        this.view.getCollectionTypeCombo().setEnabled(collectionTypeEnabled);
        this.view.getCollectionTypeLabel().setEnabled(collectionTypeEnabled);
        if (collectionTypeEnabled) {
            this.view.getCollectionTypeCombo().setSelectedItem(this.targetCollection);
        }
        boolean mapKeysEnabled = collectionTypeEnabled && COLLECTION_TYPE_MAP.equals(this.view.getCollectionTypeCombo().getSelectedItem());
        this.view.getMapKeysCombo().setEnabled(mapKeysEnabled);
        this.view.getMapKeysLabel().setEnabled(mapKeysEnabled);
        if (mapKeysEnabled) {
            this.view.getMapKeysCombo().setSelectedItem(this.mapKey);
        }
    }

    protected void clearPath() {
        this.getPathBrowser().clearSelection();
        this.setDbRelationships(new ArrayList<DbRelationship>());
    }

    protected void saveMapping() {
        if (!this.getDbRelationships().equals(this.getSavedDbRelationships()) && (this.getSavedDbRelationships().isEmpty() || JOptionPane.showConfirmDialog(this.getView(), "You have changed Db Relationship path. Do you want it to be saved?", "Save ObjRelationship", 0) == 0)) {
            this.savedDbRelationships = new ArrayList<DbRelationship>(this.dbRelationships);
        }
        this.configureRelationship();
        if (this.isCreate) {
            this.relationship.getSourceEntity().addRelationship(this.relationship);
            this.fireObjRelationshipEvent(this);
            Application.getInstance().getUndoManager().addEdit(new CreateRelationshipUndoableEdit(this.relationship.getSourceEntity(), new ObjRelationship[]{this.relationship}));
        } else {
            this.mediator.fireObjRelationshipEvent(new RelationshipEvent((Object)this, this.relationship, this.relationship.getSourceEntity(), 1));
            Application.getInstance().getUndoManager().addEdit(this.undo);
        }
        this.view.getSourceEntityLabel().setText(this.relationship.getSourceEntity().getName());
        this.view.dispose();
    }

    private void fireObjRelationshipEvent(Object src) {
        this.mediator.fireObjRelationshipEvent(new RelationshipEvent(src, this.relationship, this.relationship.getSourceEntity(), 2));
        RelationshipDisplayEvent rde = new RelationshipDisplayEvent(src, this.relationship, this.relationship.getSourceEntity(), this.mediator.getCurrentDataMap(), (DataChannelDescriptor)this.mediator.getProject().getRootNode());
        this.mediator.fireObjRelationshipDisplayEvent(rde);
    }

    public MultiColumnBrowser getPathBrowser() {
        return this.view.getPathBrowser();
    }

    protected void createRelationship() {
        DbEntity dbEntity = this.relationship.getSourceEntity().getDbEntity();
        DbRelationshipDialog dbRelationshipDialog = new DbRelationshipDialog(this.mediator).createNewRelationship(dbEntity);
        dbRelationshipDialog.startUp();
        Optional<DbRelationship> dbRelationship = dbRelationshipDialog.getRelationship();
        if (dbRelationship.isPresent()) {
            MultiColumnBrowser pathBrowser = this.getPathBrowser();
            Object[] oldPath = new Object[]{this.getStartEntity()};
            EntityTreeModel treeModel = (EntityTreeModel)pathBrowser.getModel();
            treeModel.invalidate();
            pathBrowser.setSelectionPath(new TreePath(new Object[]{this.getStartEntity()}));
            pathBrowser.repaint();
            Object[] path = new Object[oldPath.length + 1];
            System.arraycopy(oldPath, 0, path, 0, path.length - 1);
            path[path.length - 1] = dbRelationship;
            pathBrowser.setSelectionPath(new TreePath(path));
        }
    }

    public ObjectNameGenerator createNamingStrategy(String strategyClass) {
        try {
            ClassLoadingService classLoader = this.application.getClassLoadingService();
            return classLoader.loadClass(ObjectNameGenerator.class, strategyClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable th) {
            JOptionPane.showMessageDialog(this.view, "Naming Strategy Initialization Error: " + th.getMessage(), "Naming Strategy Initialization Error", 0);
            return null;
        }
    }

    private void setDeleteRule() {
        this.relationship.setDeleteRule(DeleteRule.deleteRuleForName(String.valueOf(this.view.getDeleteRule().getSelectedItem())));
    }

    private void setUsedForLocking() {
        this.relationship.setUsedForLocking(this.view.getUsedForLocking().isSelected());
    }

    private void setComment() {
        ObjectInfo.putToMetaData(this.mediator.getApplication().getMetaData(), this.relationship, "comment", this.view.getComment().getText());
    }

    private void setSemantics() {
        StringBuilder semantics = new StringBuilder(20);
        semantics.append(this.relationship.isToMany() ? "to many" : "to one");
        if (this.relationship.isReadOnly()) {
            semantics.append(", read-only");
        }
        this.view.getSemanticsLabel().setText(semantics.toString());
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath selectedPath = e.getPath();
        if (selectedPath == null || selectedPath.getPathCount() < 2) {
            return;
        }
        ArrayList<DbRelationship> relPath = new ArrayList<DbRelationship>(selectedPath.getPathCount() - 1);
        for (int i = 1; i < selectedPath.getPathCount(); ++i) {
            relPath.add((DbRelationship)selectedPath.getPathComponent(i));
        }
        this.setDbRelationships(relPath);
        this.updateCollectionChoosers();
    }

    public void setObjectTarget(ObjEntity objectTarget) {
        if (this.objectTarget != objectTarget) {
            this.objectTarget = objectTarget;
            this.initMapKeys();
        }
    }

    private void initMapKeys() {
        this.mapKeys.clear();
        this.mapKeys.add(DEFAULT_MAP_KEY);
        if (this.objectTarget == null) {
            return;
        }
        for (ObjAttribute attribute : this.objectTarget.getAttributes()) {
            this.mapKeys.add(attribute.getName());
        }
        this.view.getMapKeysCombo().removeAllItems();
        for (String s : this.mapKeys) {
            this.view.getMapKeysCombo().addItem(s);
        }
        if (this.mapKey != null && !this.mapKeys.contains(this.mapKey)) {
            this.mapKey = DEFAULT_MAP_KEY;
            this.view.getMapKeysCombo().setSelectedItem(this.mapKey);
        }
    }

    protected void updateTargetCombo(DbEntity dbTarget) {
        this.objectTargets = new ArrayList<ObjEntity>();
        if (dbTarget != null) {
            this.objectTargets.addAll(dbTarget.getDataMap().getMappedEntities(dbTarget));
            this.objectTargets.sort(Comparators.getNamedObjectComparator());
        }
        this.view.getTargetCombo().removeAllItems();
        for (ObjEntity s : this.objectTargets) {
            this.view.getTargetCombo().addItem(s.getName());
        }
    }

    public List<DbRelationship> getDbRelationships() {
        return this.dbRelationships;
    }

    public List<DbRelationship> getSavedDbRelationships() {
        return this.savedDbRelationships;
    }

    public DbRelationship getLastRelationship() {
        return this.dbRelationships.size() == 0 ? null : this.dbRelationships.get(this.dbRelationships.size() - 1);
    }

    public void setDbRelationships(List<DbRelationship> rels) {
        this.dbRelationships = rels;
        this.view.getSaveButton().setEnabled(true);
        this.updateTargetCombo(rels.size() > 0 ? rels.get(rels.size() - 1).getTargetEntity() : null);
        this.updateCollectionChoosers();
    }

    public ObjEntity getObjectTarget() {
        return this.objectTarget;
    }

    public List<ObjEntity> getObjectTargets() {
        return this.objectTargets;
    }

    public String getRelationshipName() {
        return this.view.getRelationshipName().getText();
    }

    public void setRelationshipName(String relationshipName) {
        this.view.getRelationshipName().setText(relationshipName);
    }

    public void relationshipChanged(int index) {
        this.breakChain(index);
        this.connectEnds();
    }

    public boolean isToMany() {
        for (DbRelationship relationship : this.dbRelationships) {
            if (relationship == null || !relationship.isToMany()) continue;
            return true;
        }
        return false;
    }

    public boolean configureRelationship() {
        String mapKey;
        String collectionType;
        List<DbRelationship> oldPath;
        boolean hasChanges = false;
        boolean oldToMany = this.relationship.isToMany();
        boolean oldPathNotEmpty = !this.relationship.getDbRelationships().isEmpty();
        String relationshipName = this.getRelationshipName();
        if (!Util.nullSafeEquals(this.relationship.getName(), relationshipName)) {
            ProjectUtil.setRelationshipName(this.relationship.getSourceEntity(), this.relationship, relationshipName);
            hasChanges = true;
        }
        if (this.savedDbRelationships.size() > 0) {
            DbEntity lastEntity = this.savedDbRelationships.get(this.savedDbRelationships.size() - 1).getTargetEntity();
            if (this.objectTarget == null || this.objectTarget.getDbEntity() != lastEntity) {
                Collection<ObjEntity> objEntities = lastEntity.getDataMap().getMappedEntities(lastEntity);
                ObjEntity objEntity = this.objectTarget = objEntities.size() == 0 ? null : objEntities.iterator().next();
            }
        }
        if (this.objectTarget == null || !Util.nullSafeEquals(this.objectTarget.getName(), this.relationship.getTargetEntityName())) {
            hasChanges = true;
            this.relationship.setTargetEntityName(this.objectTarget);
        }
        if ((oldPath = this.relationship.getDbRelationships()).size() != this.savedDbRelationships.size()) {
            hasChanges = true;
            this.updatePath();
        } else {
            for (int i = 0; i < oldPath.size(); ++i) {
                DbRelationship next = this.savedDbRelationships.get(i);
                if (oldPath.get(i) == next) continue;
                hasChanges = true;
                this.updatePath();
                break;
            }
        }
        String string = collectionType = "java.util.List".equals(this.targetCollection) || !this.relationship.isToMany() ? null : this.targetCollection;
        if (!Util.nullSafeEquals(collectionType, this.relationship.getCollectionType())) {
            hasChanges = true;
            this.relationship.setCollectionType(collectionType);
        }
        String string2 = mapKey = COLLECTION_TYPE_MAP.equals(collectionType) && !DEFAULT_MAP_KEY.equals(this.mapKey) ? this.mapKey : null;
        if (!Util.nullSafeEquals(mapKey, this.relationship.getMapKey())) {
            hasChanges = true;
            this.relationship.setMapKey(mapKey);
        }
        if (oldPathNotEmpty && hasChanges && this.relationship.isToMany() != oldToMany) {
            DeleteRuleUpdater.updateObjRelationship(this.relationship);
        }
        return hasChanges;
    }

    private void updatePath() {
        this.relationship.clearDbRelationships();
        for (DbRelationship nextPathComponent : this.dbRelationships) {
            if (nextPathComponent == null) break;
            this.relationship.addDbRelationship(nextPathComponent);
        }
    }

    private void breakChain(int index) {
        while (this.dbRelationships.size() > index + 1) {
            this.dbRelationships.remove(this.dbRelationships.size() - 1);
        }
    }

    private void connectEnds() {
        DbEntity target;
        DbRelationship last = null;
        int size = this.dbRelationships.size();
        if (size > 0) {
            last = this.dbRelationships.get(size - 1);
        }
        if ((target = this.getEndEntity()) != null && (last == null || last.getTargetEntity() != target)) {
            DbRelationship anyConnector;
            DbEntity source;
            DbEntity dbEntity = source = last == null ? this.getStartEntity() : last.getTargetEntity();
            if (source != null && (anyConnector = (DbRelationship)source.getAnyRelationship(target)) != null) {
                this.dbRelationships.add(anyConnector);
            }
        }
    }

    private void validateCanMap() {
        if (this.relationship.getSourceEntity() == null) {
            throw new CayenneRuntimeException("Can't map relationship without source entity.", new Object[0]);
        }
        if (this.getStartEntity() == null) {
            JOptionPane.showMessageDialog(this.getView(), "Can't map relationship without source DbEntity. Set source DbEntity.");
            throw new CayenneRuntimeException("Can't map relationship without source DbEntity.", new Object[0]);
        }
    }

    public DbEntity getStartEntity() {
        return this.relationship.getSourceEntity().getDbEntity();
    }

    public DbEntity getEndEntity() {
        if (this.objectTarget == null) {
            return null;
        }
        return this.objectTarget.getDbEntity();
    }

    public String getMapKey() {
        return this.mapKey;
    }

    public void setMapKey(String mapKey) {
        this.mapKey = mapKey;
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    public String getTargetCollection() {
        return this.targetCollection;
    }

    public void setTargetCollection(String targetCollection) {
        this.targetCollection = targetCollection;
    }

    public List<String> getMapKeys() {
        return this.mapKeys;
    }

    public List<String> getTargetCollections() {
        return this.targetCollections;
    }
}

