/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db.load;

import java.io.File;
import java.sql.Connection;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.dbsync.reverse.dbimport.DbImportConfiguration;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.filters.FiltersConfigBuilder;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ClassLoadingService;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.db.load.LoaderDelegate;
import org.apache.cayenne.modeler.editor.dbimport.DbImportView;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbLoaderContext {
    private static Logger LOGGER = LoggerFactory.getLogger(DbLoaderContext.class);
    private DbImportConfiguration config;
    private Connection connection;
    private ProjectController projectController;
    private boolean existingMap;
    private DataMap dataMap;
    private boolean stopping;
    private String loadStatusNote;
    private volatile boolean isInterrupted;
    private DataChannelMetaData metaData;

    public DbLoaderContext(DataChannelMetaData metaData) {
        this.metaData = metaData;
    }

    DataMap getDataMap() {
        return this.dataMap;
    }

    boolean isExistingDataMap() {
        return this.existingMap;
    }

    public void setProjectController(ProjectController projectController) {
        this.projectController = projectController;
    }

    ProjectController getProjectController() {
        return this.projectController;
    }

    void setConfig(DbImportConfiguration config) {
        this.config = config;
    }

    DbImportConfiguration getConfig() {
        return this.config;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public DataChannelMetaData getMetaData() {
        return this.metaData;
    }

    void setStopping(boolean stopping) {
        this.stopping = stopping;
    }

    String getStatusNote() {
        return this.loadStatusNote;
    }

    void setStatusNote(String loadStatusNote) {
        this.loadStatusNote = loadStatusNote;
    }

    private void fillReverseEngineeringFromView(ReverseEngineering reverseEngineering, DbImportView view) {
        reverseEngineering.setUseJava7Types(view.isUseJava7Typed());
        reverseEngineering.setForceDataMapCatalog(view.isForceDataMapCatalog());
        reverseEngineering.setForceDataMapSchema(view.isForceDataMapSchema());
        reverseEngineering.setSkipRelationshipsLoading(view.isSkipRelationshipsLoading());
        reverseEngineering.setSkipPrimaryKeyLoading(view.isSkipPrimaryKeyLoading());
        reverseEngineering.setMeaningfulPkTables(view.getMeaningfulPk());
        reverseEngineering.setNamingStrategy(view.getNamingStrategy());
        reverseEngineering.setStripFromTableNames(view.getStripFromTableNames());
    }

    public boolean buildConfig(DBConnectionInfo connectionInfo, DbImportView view, boolean headless) {
        if (connectionInfo == null) {
            return false;
        }
        ReverseEngineering metaReverseEngineering = this.metaData.get(this.getProjectController().getCurrentDataMap(), ReverseEngineering.class);
        if (metaReverseEngineering == null) {
            return false;
        }
        if (!headless) {
            this.fillReverseEngineeringFromView(metaReverseEngineering, view);
        }
        ReverseEngineering reverseEngineering = new ReverseEngineering(metaReverseEngineering);
        DbImportConfiguration config = new DbImportConfiguration(){

            @Override
            public DbLoaderDelegate createLoaderDelegate() {
                return new LoaderDelegate(DbLoaderContext.this);
            }
        };
        this.fillConfig(config, connectionInfo, reverseEngineering);
        this.setConfig(config);
        this.prepareDataMap();
        return true;
    }

    private void fillConfig(DbImportConfiguration config, DBConnectionInfo connectionInfo, ReverseEngineering reverseEngineering) {
        config.setAdapter(connectionInfo.getDbAdapter());
        config.setUsername(connectionInfo.getUserName());
        config.setPassword(connectionInfo.getPassword());
        config.setDriver(connectionInfo.getJdbcDriver());
        config.setUrl(connectionInfo.getUrl());
        try {
            ClassLoadingService classLoadingService = Application.getInstance().getClassLoadingService();
            config.getDbLoaderConfig().setFiltersConfig(new FiltersConfigBuilder(reverseEngineering).dataSource(connectionInfo.makeDataSource(classLoadingService)).dbAdapter(connectionInfo.makeAdapter(classLoadingService)).build());
        }
        catch (Exception e) {
            this.processException(e, "Fail while building configs.");
        }
        config.setMeaningfulPkTables(reverseEngineering.getMeaningfulPkTables());
        config.setNamingStrategy(reverseEngineering.getNamingStrategy());
        config.setDefaultPackage(reverseEngineering.getDefaultPackage());
        config.setStripFromTableNames(reverseEngineering.getStripFromTableNames());
        config.setUseJava7Types(reverseEngineering.isUseJava7Types());
        config.setForceDataMapCatalog(reverseEngineering.isForceDataMapCatalog());
        config.setForceDataMapSchema(reverseEngineering.isForceDataMapSchema());
        config.setSkipRelationshipsLoading(reverseEngineering.getSkipRelationshipsLoading());
        config.setSkipPrimaryKeyLoading(reverseEngineering.getSkipPrimaryKeyLoading());
        String[] tableTypes = reverseEngineering.getTableTypes();
        if (tableTypes.length != 0) {
            config.setTableTypes(tableTypes);
        } else {
            config.setTableTypes(new String[]{"TABLE", "VIEW"});
        }
    }

    private void prepareDataMap() {
        this.dataMap = this.getProjectController().getCurrentDataMap();
        boolean bl = this.existingMap = this.dataMap != null;
        if (!this.existingMap) {
            ConfigurationNode root = this.getProjectController().getProject().getRootNode();
            this.dataMap = new DataMap();
            this.dataMap.setName(NameBuilder.builder(this.dataMap, root).name());
        }
        if (this.dataMap.getConfigurationSource() != null) {
            this.getConfig().setTargetDataMap(new File(this.dataMap.getConfigurationSource().getURL().getPath()));
        }
    }

    public void processWarn(Throwable th, String message) {
        LOGGER.warn(message, Util.unwindException(th));
    }

    public void processException(Throwable th, String message) {
        LOGGER.info("Exception on reverse engineering", Util.unwindException(th));
        this.isInterrupted = true;
        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(Application.getFrame(), th.getMessage(), message, 0));
    }

    public boolean isInterrupted() {
        return this.isInterrupted;
    }
}

