/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.datamap;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.EmbeddableEvent;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesController;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesView;
import org.apache.cayenne.util.Util;

public class PackageUpdateController
extends DefaultsPreferencesController {
    public static final String ALL_CONTROL = "Set/update package for all ObjEntities and Embeddables (create default class names if missing)";
    public static final String UNINIT_CONTROL = "Do not override class names with packages";
    protected DefaultsPreferencesView view;

    public PackageUpdateController(ProjectController mediator, DataMap dataMap) {
        super(mediator, dataMap);
    }

    public void startupAction() {
        this.view = new DefaultsPreferencesView(ALL_CONTROL, UNINIT_CONTROL);
        this.view.setTitle("Update ObjEntities and Embeddables Java Package");
        this.initController();
        this.view.pack();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
    }

    @Override
    public Component getView() {
        return this.view;
    }

    private void initController() {
        this.view.getCancelButton().addActionListener(e -> this.view.dispose());
        this.view.getUpdateButton().addActionListener(e -> this.updatePackage());
    }

    protected void updatePackage() {
        String oldName;
        boolean doAll = this.isAllEntities();
        HashMap<String, String> oldNameEmbeddableToNewName = new HashMap<String, String>();
        ArrayList<Embeddable> embeddables = new ArrayList<Embeddable>(this.dataMap.getEmbeddables());
        for (Embeddable embeddable : embeddables) {
            oldName = embeddable.getClassName();
            String[] tokens = oldName.split("\\.");
            String className = tokens[tokens.length - 1];
            if (!doAll && !Util.isEmptyString(oldName) && oldName.indexOf(46) >= 0) continue;
            EmbeddableEvent e = new EmbeddableEvent((Object)this, embeddable, embeddable.getClassName());
            String newClassName = this.getNameWithDefaultPackage(className);
            oldNameEmbeddableToNewName.put(oldName, newClassName);
            embeddable.setClassName(newClassName);
            this.mediator.fireEmbeddableEvent(e, this.mediator.getCurrentDataMap());
        }
        for (ObjEntity entity : this.dataMap.getObjEntities()) {
            oldName = this.getClassName(entity);
            if (doAll || Util.isEmptyString(oldName) || oldName.indexOf(46) < 0) {
                String className = this.extractClassName(Util.isEmptyString(oldName) ? entity.getName() : oldName);
                this.setClassName(entity, this.getNameWithDefaultPackage(className));
            }
            for (ObjAttribute attribute : entity.getAttributes()) {
                if (!(attribute instanceof EmbeddedAttribute) || oldNameEmbeddableToNewName.size() <= 0 || !oldNameEmbeddableToNewName.containsKey(attribute.getType())) continue;
                attribute.setType((String)oldNameEmbeddableToNewName.get(attribute.getType()));
                AttributeEvent ev = new AttributeEvent((Object)this, attribute, entity);
                this.mediator.fireObjAttributeEvent(ev);
            }
        }
        this.view.dispose();
    }

    protected String extractClassName(String name) {
        if (name == null) {
            return "";
        }
        int dot = name.lastIndexOf(46);
        return dot < 0 ? name : (dot + 1 < name.length() ? name.substring(dot + 1) : "");
    }

    protected String getNameWithDefaultPackage(String name) {
        return this.dataMap.getNameWithDefaultPackage(name);
    }

    protected String getClassName(ObjEntity entity) {
        return entity.getClassName();
    }

    protected void setClassName(ObjEntity entity, String newName) {
        if (!Util.nullSafeEquals(newName, this.getClassName(entity))) {
            entity.setClassName(newName);
            this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
        }
    }
}

