/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.mysql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.cayenne.configuration.runtime.DbAdapterDetector;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.mysql.MySQLAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;

public class MySQLSniffer
implements DbAdapterDetector {
    protected AdhocObjectFactory objectFactory;

    public MySQLSniffer(@Inject AdhocObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public DbAdapter createAdapter(DatabaseMetaData md) throws SQLException {
        String dbName = md.getDatabaseProductName();
        if (dbName == null || !dbName.toUpperCase().contains("MYSQL")) {
            return null;
        }
        String adapterStorageEngine = "InnoDB";
        try (Statement statement = md.getConnection().createStatement();
             ResultSet rs = statement.executeQuery("SHOW VARIABLES LIKE 'table_type'");){
            String storageEngine;
            if (rs.next() && (storageEngine = rs.getString(2)) != null) {
                adapterStorageEngine = storageEngine;
            }
        }
        MySQLAdapter adapter = this.objectFactory.newInstance(MySQLAdapter.class, MySQLAdapter.class.getName());
        adapter.setStorageEngine(adapterStorageEngine);
        return adapter;
    }
}

