/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.DataSourceDescriptor;
import org.apache.cayenne.configuration.xml.DataNodeChildrenHandler;
import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.configuration.xml.XMLDataChannelDescriptorLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

class DataSourceChildrenHandler
extends NamespaceAwareNestedTagHandler {
    private static final Logger logger = LoggerFactory.getLogger(XMLDataChannelDescriptorLoader.class);
    static final String DRIVER_TAG = "driver";
    static final String LOGIN_TAG = "login";
    static final String URL_TAG = "url";
    static final String CONNECTION_POOL_TAG = "connectionPool";
    private XMLDataChannelDescriptorLoader xmlDataChannelDescriptorLoader;
    private DataSourceDescriptor dataSourceDescriptor;

    DataSourceChildrenHandler(XMLDataChannelDescriptorLoader xmlDataChannelDescriptorLoader, DataNodeChildrenHandler parentHandler, DataSourceDescriptor dataSourceDescriptor) {
        super(parentHandler);
        this.xmlDataChannelDescriptorLoader = xmlDataChannelDescriptorLoader;
        this.dataSourceDescriptor = dataSourceDescriptor;
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) {
        switch (localName) {
            case "driver": {
                this.dataSourceDescriptor.setJdbcDriver(attributes.getValue("value"));
                return true;
            }
            case "login": {
                this.configureCredentials(attributes);
                return true;
            }
            case "url": {
                this.dataSourceDescriptor.setDataSourceUrl(attributes.getValue("value"));
                return true;
            }
            case "connectionPool": {
                this.configureConnectionPool(attributes);
                return true;
            }
        }
        return false;
    }

    void configureCredentials(Attributes attributes) {
        String password = attributes.getValue("password");
        String username = attributes.getValue("userName");
        this.dataSourceDescriptor.setUserName(username);
        this.dataSourceDescriptor.setPassword(password);
    }

    void configureConnectionPool(Attributes attributes) {
        String max;
        String min = attributes.getValue("min");
        if (min != null) {
            try {
                this.dataSourceDescriptor.setMinConnections(Integer.parseInt(min));
            }
            catch (NumberFormatException nfex) {
                logger.info("Non-numeric 'min' attribute", nfex);
                throw new ConfigurationException("Non-numeric 'min' attribute '%s'", (Throwable)nfex, min);
            }
        }
        if ((max = attributes.getValue("max")) != null) {
            try {
                this.dataSourceDescriptor.setMaxConnections(Integer.parseInt(max));
            }
            catch (NumberFormatException nfex) {
                logger.info("Non-numeric 'max' attribute", nfex);
                throw new ConfigurationException("Non-numeric 'max' attribute '%s'", (Throwable)nfex, max);
            }
        }
    }
}

