package org.apache.cayenne.testdo.relationships.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

import org.apache.cayenne.PersistentObject;
import org.apache.cayenne.exp.property.EntityProperty;
import org.apache.cayenne.exp.property.ListProperty;
import org.apache.cayenne.exp.property.NumericIdProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.SelfProperty;
import org.apache.cayenne.exp.property.StringProperty;
import org.apache.cayenne.testdo.relationships.E1;
import org.apache.cayenne.testdo.relationships.E2;

/**
 * Class _E2 was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _E2 extends PersistentObject {

    private static final long serialVersionUID = 1L;

    public static final SelfProperty<E2> SELF = PropertyFactory.createSelf(E2.class);

    public static final NumericIdProperty<Integer> ID_PK_PROPERTY = PropertyFactory.createNumericId("id", "CYCLE_E2", Integer.class);
    public static final String ID_PK_COLUMN = "id";

    public static final StringProperty<String> TEXT = PropertyFactory.createString("text", String.class);
    public static final EntityProperty<E1> E1 = PropertyFactory.createEntity("e1", E1.class);
    public static final ListProperty<E1> E1S = PropertyFactory.createList("e1s", E1.class);

    protected String text;

    protected Object e1;
    protected Object e1s;

    public void setText(String text) {
        beforePropertyWrite("text", this.text, text);
        this.text = text;
    }

    public String getText() {
        beforePropertyRead("text");
        return this.text;
    }

    public void setE1(E1 e1) {
        setToOneTarget("e1", e1, true);
    }

    public E1 getE1() {
        return (E1)readProperty("e1");
    }

    public void addToE1s(E1 obj) {
        addToManyTarget("e1s", obj, true);
    }

    public void removeFromE1s(E1 obj) {
        removeToManyTarget("e1s", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<E1> getE1s() {
        return (List<E1>)readProperty("e1s");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "text":
                return this.text;
            case "e1":
                return this.e1;
            case "e1s":
                return this.e1s;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "text":
                this.text = (String)val;
                break;
            case "e1":
                this.e1 = val;
                break;
            case "e1s":
                this.e1s = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.text);
        out.writeObject(this.e1);
        out.writeObject(this.e1s);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.text = (String)in.readObject();
        this.e1 = in.readObject();
        this.e1s = in.readObject();
    }

}
