package org.apache.cayenne.testdo.map_to_many.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;

import org.apache.cayenne.PersistentObject;
import org.apache.cayenne.exp.property.MapProperty;
import org.apache.cayenne.exp.property.NumericIdProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.SelfProperty;
import org.apache.cayenne.testdo.map_to_many.IdMapToMany;
import org.apache.cayenne.testdo.map_to_many.IdMapToManyTarget;

/**
 * Class _IdMapToMany was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _IdMapToMany extends PersistentObject {

    private static final long serialVersionUID = 1L;

    public static final SelfProperty<IdMapToMany> SELF = PropertyFactory.createSelf(IdMapToMany.class);

    public static final NumericIdProperty<Integer> ID_PK_PROPERTY = PropertyFactory.createNumericId("ID", "IdMapToMany", Integer.class);
    public static final String ID_PK_COLUMN = "ID";

    public static final MapProperty<Object, IdMapToManyTarget> TARGETS = PropertyFactory.createMap("targets", Object.class, IdMapToManyTarget.class);


    protected Object targets;

    public void addToTargets(IdMapToManyTarget obj) {
        addToManyTarget("targets", obj, true);
    }

    public void removeFromTargets(IdMapToManyTarget obj) {
        removeToManyTarget("targets", obj, true);
    }

    @SuppressWarnings("unchecked")
    public Map<Object, IdMapToManyTarget> getTargets() {
        return (Map<Object, IdMapToManyTarget>)readProperty("targets");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "targets":
                return this.targets;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "targets":
                this.targets = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.targets);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.targets = in.readObject();
    }

}
