/*****************************************************************
 *   Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 ****************************************************************/

package org.apache.cayenne.template.directive;

import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.template.Context;

/**
 * @since 4.1
 */
public class BindObjectNotEqual extends BindObjectEqual {

    public static final BindObjectNotEqual INSTANCE = new BindObjectNotEqual();

    @Override
    protected void renderColumn(Context context, String columnName, int columnIndex) {
        if (columnIndex > 0) {
            context.getBuilder().append(" OR ");
        }

        context.getBuilder().append(columnName).append(' ');
    }

    @Override
    protected void render(Context context, ParameterBinding binding) {
        if (binding.getValue() != null) {
            context.addParameterBinding(binding);
            context.getBuilder().append("<> ?");
        } else {
            context.getBuilder().append("IS NOT NULL");
        }
    }

}
