/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db.load;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.DataChannelDescriptorLoader;
import org.apache.cayenne.configuration.DataMapLoader;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.DbAdapterFactory;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactoryProvider;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.reverse.dbimport.DbImportConfiguration;
import org.apache.cayenne.dbsync.reverse.dbimport.DefaultDbImportAction;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.dialog.db.load.DbLoadResultDialog;
import org.apache.cayenne.modeler.editor.DbImportController;
import org.apache.cayenne.project.ProjectSaver;
import org.slf4j.Logger;

public class ModelerDbImportAction
extends DefaultDbImportAction {
    @Inject
    private DataMap targetMap;
    private DataMap sourceDataMap;
    private DbImportConfiguration config;
    private DbLoadResultDialog resultDialog;
    private DbImportController dbImportController = Application.getInstance().getFrameController().getDbImportController();

    public ModelerDbImportAction(@Inject Logger logger, @Inject ProjectSaver projectSaver, @Inject DataSourceFactory dataSourceFactory, @Inject DbAdapterFactory adapterFactory, @Inject DataMapLoader mapLoader, @Inject MergerTokenFactoryProvider mergerTokenFactoryProvider, @Inject DataChannelMetaData metaData, @Inject DataChannelDescriptorLoader dataChannelDescriptorLoader) {
        super(logger, projectSaver, dataSourceFactory, adapterFactory, mapLoader, mergerTokenFactoryProvider, dataChannelDescriptorLoader, metaData);
    }

    @Override
    public void execute(DbImportConfiguration config) throws Exception {
        this.config = config;
        this.sourceDataMap = this.loadDataMap(config);
    }

    public void commit() throws Exception {
        this.commit(this.config, this.sourceDataMap);
    }

    @Override
    protected Collection<MergerToken> log(List<MergerToken> tokens) {
        this.resultDialog = this.dbImportController.createDialog();
        this.resultDialog.refreshElements();
        this.resultDialog.getOkButton().addActionListener(e -> {
            try {
                if (this.resultDialog.getTableForMap().containsKey(this.targetMap)) {
                    this.commit();
                    this.checkForUnusedImports();
                }
            }
            catch (Exception ex) {
                throw new CayenneRuntimeException("Nothing to commit.", new Object[0]);
            }
        });
        this.resultDialog.getRevertButton().addActionListener(e -> this.resetDialog());
        this.resultDialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ModelerDbImportAction.this.resetDialog();
            }
        });
        this.logger.info("");
        if (tokens.isEmpty()) {
            this.logger.info("Detected changes: No changes to import.");
            String logString = String.format("    %-20s", "Nothing to import");
            this.resultDialog.getRevertButton().setVisible(false);
            this.resultDialog.addRowToOutput(logString, this.targetMap);
            return tokens;
        }
        this.logger.info("Detected changes: ");
        for (MergerToken token : tokens) {
            String logString = String.format("    %-20s %s", token.getTokenName(), token.getTokenValue());
            this.logger.info(logString);
            this.resultDialog.addRowToOutput(logString, this.targetMap);
        }
        this.logger.info("");
        return tokens;
    }

    private void resetDialog() {
        this.resultDialog.setVisible(false);
        this.dbImportController.resetDialog();
    }

    private void checkForUnusedImports() {
        this.resetDialog();
        this.dbImportController.setGlobalImport(false);
    }

    @Override
    protected DataMap existingTargetMap(DbImportConfiguration configuration) {
        return this.targetMap;
    }
}

