/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.codec.json;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.gridkit.jvmtool.event.CommonEvent;
import org.gridkit.jvmtool.spi.parsers.JsonEventSource;
import org.gridkit.jvmtool.stacktrace.codec.json.JfrExecutionSampleHandler;
import org.gridkit.jvmtool.stacktrace.codec.json.JfrJavaExceptionThrowHandler;
import org.gridkit.jvmtool.stacktrace.codec.json.JfrNativeMethodSampleHandler;
import org.gridkit.jvmtool.stacktrace.codec.json.JfrObjectAllocationInNewTLAB;
import org.gridkit.jvmtool.stacktrace.codec.json.JsonEventAdapter;
import org.gridkit.jvmtool.stacktrace.codec.json.JsonStreamHandler;

public class JfrEventParser
implements JsonEventAdapter {
    private JsonStreamHandler streamHandler = new JsonStreamHandler();
    private ObjectHandlerProxy handlerProxy = new ObjectHandlerProxy();
    private CommonEvent nextEvent;

    @Override
    public CommonEvent parseNextEvent(JsonEventSource source) throws IOException {
        this.nextEvent = null;
        do {
            this.streamHandler.reset(this.handlerProxy);
            if (!source.readNext(this.streamHandler)) {
                return null;
            }
            if (this.streamHandler.isAcomplished()) continue;
            throw new IOException("Malformed JSON input");
        } while (this.nextEvent == null);
        return this.nextEvent;
    }

    public void push(CommonEvent nextEvent) {
        if (this.nextEvent != null) {
            throw new IllegalStateException("Event is already slotted");
        }
        this.nextEvent = nextEvent;
    }

    protected JsonStreamHandler.JsonObjectHandler createEventHandler(String typeId) {
        if ("jdk.ExecutionSample".equals(typeId)) {
            return new JfrExecutionSampleHandler(this);
        }
        if ("jdk.NativeMethodSample".equals(typeId)) {
            return new JfrNativeMethodSampleHandler(this);
        }
        if ("jdk.JavaExceptionThrow".equals(typeId)) {
            return new JfrJavaExceptionThrowHandler(this);
        }
        if ("jdk.ObjectAllocationInNewTLAB".equals(typeId)) {
            return new JfrObjectAllocationInNewTLAB(this);
        }
        return JsonStreamHandler.NULL_HANDLER;
    }

    private class ObjectHandlerProxy
    implements JsonStreamHandler.JsonObjectHandler {
        private Map<String, JsonStreamHandler.JsonObjectHandler> handlerCache = new HashMap<String, JsonStreamHandler.JsonObjectHandler>();
        private JsonStreamHandler.JsonObjectHandler delegate;

        private ObjectHandlerProxy() {
        }

        @Override
        public void onScalarFieldValue(String fieldName, Object val) {
            if (this.delegate != null) {
                this.delegate.onScalarFieldValue(fieldName, val);
            } else if ("eventType".equals(fieldName)) {
                String type = String.valueOf(val);
                JsonStreamHandler.JsonObjectHandler h2 = this.handlerCache.get(type);
                if (h2 == null) {
                    h2 = JfrEventParser.this.createEventHandler((String)val);
                    this.handlerCache.put(type, h2);
                }
                this.delegate = h2;
            } else {
                throw new IllegalStateException("Unexpected field '" + fieldName + "', 'eventType' is expected");
            }
        }

        @Override
        public JsonStreamHandler.JsonEntityHandler onEntityField(String fieldName) {
            if (this.delegate != null) {
                return this.delegate.onEntityField(fieldName);
            }
            throw new IllegalStateException("Unexpected field '" + fieldName + "', 'eventType' is expected");
        }

        @Override
        public void onObjectComplete() {
            if (this.delegate != null) {
                this.delegate.onObjectComplete();
            }
        }
    }
}

