/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;

public class NoSpamLogger {
    @VisibleForTesting
    static Clock CLOCK = new Clock(){

        @Override
        public long nanoTime() {
            return System.nanoTime();
        }
    };
    private static final NonBlockingHashMap<Logger, NoSpamLogger> wrappedLoggers = new NonBlockingHashMap();
    private final Logger wrapped;
    private final long minIntervalNanos;
    private final NonBlockingHashMap<String, NoSpamLogStatement> lastMessage = new NonBlockingHashMap();

    @VisibleForTesting
    static void clearWrappedLoggersForTest() {
        wrappedLoggers.clear();
    }

    public static NoSpamLogger getLogger(Logger logger, long minInterval, TimeUnit unit) {
        NoSpamLogger temp;
        NoSpamLogger wrapped = wrappedLoggers.get(logger);
        if (wrapped == null && (temp = wrappedLoggers.putIfAbsent(logger, wrapped = new NoSpamLogger(logger, minInterval, unit))) != null) {
            wrapped = temp;
        }
        return wrapped;
    }

    public static boolean log(Logger logger, Level level, long minInterval, TimeUnit unit, String message, Object ... objects) {
        return NoSpamLogger.log(logger, level, message, minInterval, unit, CLOCK.nanoTime(), message, objects);
    }

    public static boolean log(Logger logger, Level level, String key, long minInterval, TimeUnit unit, String message, Object ... objects) {
        return NoSpamLogger.log(logger, level, key, minInterval, unit, CLOCK.nanoTime(), message, objects);
    }

    public static boolean log(Logger logger, Level level, String key, long minInterval, TimeUnit unit, long nowNanos, String message, Object ... objects) {
        NoSpamLogger wrapped = NoSpamLogger.getLogger(logger, minInterval, unit);
        NoSpamLogStatement statement = wrapped.getStatement(key, message);
        return statement.log(level, nowNanos, objects);
    }

    public static NoSpamLogStatement getStatement(Logger logger, String message, long minInterval, TimeUnit unit) {
        NoSpamLogger wrapped = NoSpamLogger.getLogger(logger, minInterval, unit);
        return wrapped.getStatement(message);
    }

    private NoSpamLogger(Logger wrapped, long minInterval, TimeUnit timeUnit) {
        this.wrapped = wrapped;
        this.minIntervalNanos = timeUnit.toNanos(minInterval);
    }

    public boolean info(long nowNanos, String s2, Object ... objects) {
        return this.log(Level.INFO, s2, nowNanos, objects);
    }

    public boolean info(String s2, Object ... objects) {
        return this.info(CLOCK.nanoTime(), s2, objects);
    }

    public boolean warn(long nowNanos, String s2, Object ... objects) {
        return this.log(Level.WARN, s2, nowNanos, objects);
    }

    public boolean warn(String s2, Object ... objects) {
        return this.warn(CLOCK.nanoTime(), s2, objects);
    }

    public boolean error(long nowNanos, String s2, Object ... objects) {
        return this.log(Level.ERROR, s2, nowNanos, objects);
    }

    public boolean error(String s2, Object ... objects) {
        return this.error(CLOCK.nanoTime(), s2, objects);
    }

    public boolean log(Level l, String s2, long nowNanos, Object ... objects) {
        return this.getStatement(s2, this.minIntervalNanos).log(l, nowNanos, objects);
    }

    public NoSpamLogStatement getStatement(String s2) {
        return this.getStatement(s2, this.minIntervalNanos);
    }

    public NoSpamLogStatement getStatement(String key, String s2) {
        return this.getStatement(key, s2, this.minIntervalNanos);
    }

    public NoSpamLogStatement getStatement(String s2, long minInterval, TimeUnit unit) {
        return this.getStatement(s2, unit.toNanos(minInterval));
    }

    public NoSpamLogStatement getStatement(String s2, long minIntervalNanos) {
        return this.getStatement(s2, s2, minIntervalNanos);
    }

    public NoSpamLogStatement getStatement(String key, String s2, long minIntervalNanos) {
        NoSpamLogStatement temp;
        NoSpamLogStatement statement = this.lastMessage.get(key);
        if (statement == null && (temp = this.lastMessage.putIfAbsent(key, statement = new NoSpamLogStatement(s2, minIntervalNanos))) != null) {
            statement = temp;
        }
        return statement;
    }

    public class NoSpamLogStatement
    extends AtomicLong {
        private static final long serialVersionUID = 1L;
        private final String statement;
        private final long minIntervalNanos;

        public NoSpamLogStatement(String statement, long minIntervalNanos) {
            super(Long.MIN_VALUE);
            this.statement = statement;
            this.minIntervalNanos = minIntervalNanos;
        }

        private boolean shouldLog(long nowNanos) {
            long expected = this.get();
            return nowNanos >= expected && this.compareAndSet(expected, nowNanos + this.minIntervalNanos);
        }

        public boolean log(Level l, long nowNanos, Object ... objects) {
            if (!this.shouldLog(nowNanos)) {
                return false;
            }
            switch (l) {
                case INFO: {
                    NoSpamLogger.this.wrapped.info(this.statement, objects);
                    break;
                }
                case WARN: {
                    NoSpamLogger.this.wrapped.warn(this.statement, objects);
                    break;
                }
                case ERROR: {
                    NoSpamLogger.this.wrapped.error(this.statement, objects);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return true;
        }

        public boolean info(long nowNanos, Object ... objects) {
            return this.log(Level.INFO, nowNanos, objects);
        }

        public boolean info(Object ... objects) {
            return this.info(CLOCK.nanoTime(), objects);
        }

        public boolean warn(long nowNanos, Object ... objects) {
            return this.log(Level.WARN, nowNanos, objects);
        }

        public boolean warn(Object ... objects) {
            return this.warn(CLOCK.nanoTime(), objects);
        }

        public boolean error(long nowNanos, Object ... objects) {
            return this.log(Level.ERROR, nowNanos, objects);
        }

        public boolean error(Object ... objects) {
            return this.error(CLOCK.nanoTime(), objects);
        }
    }

    @VisibleForTesting
    static interface Clock {
        public long nanoTime();
    }

    public static enum Level {
        INFO,
        WARN,
        ERROR;

    }
}

