/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.SyncNodePair;
import org.apache.cassandra.repair.SyncStat;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.repair.messages.SyncRequest;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SyncTask
extends AbstractFuture<SyncStat>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SyncTask.class);
    protected final RepairJobDesc desc;
    @VisibleForTesting
    public final List<Range<Token>> rangesToSync;
    protected final PreviewKind previewKind;
    protected final SyncNodePair nodePair;
    protected volatile long startTime = Long.MIN_VALUE;
    protected final SyncStat stat;

    protected SyncTask(RepairJobDesc desc, InetAddressAndPort primaryEndpoint, InetAddressAndPort peer, List<Range<Token>> rangesToSync, PreviewKind previewKind) {
        Preconditions.checkArgument(!peer.equals(primaryEndpoint), "Sending and receiving node are the same: %s", (Object)peer);
        this.desc = desc;
        this.rangesToSync = rangesToSync;
        this.nodePair = new SyncNodePair(primaryEndpoint, peer);
        this.previewKind = previewKind;
        this.stat = new SyncStat(this.nodePair, rangesToSync.size());
    }

    protected abstract void startSync();

    public SyncNodePair nodePair() {
        return this.nodePair;
    }

    @Override
    public final void run() {
        this.startTime = System.currentTimeMillis();
        String format = String.format("%s Endpoints %s and %s %%s for %s", this.previewKind.logPrefix(this.desc.sessionId), this.nodePair.coordinator, this.nodePair.peer, this.desc.columnFamily);
        if (this.rangesToSync.isEmpty()) {
            logger.info(String.format(format, "are consistent"));
            Tracing.traceRepair("Endpoint {} is consistent with {} for {}", this.nodePair.coordinator, this.nodePair.peer, this.desc.columnFamily);
            this.set(this.stat);
            return;
        }
        logger.info(String.format(format, "have " + this.rangesToSync.size() + " range(s) out of sync"));
        Tracing.traceRepair("Endpoint {} has {} range(s) out of sync with {} for {}", this.nodePair.coordinator, this.rangesToSync.size(), this.nodePair.peer, this.desc.columnFamily);
        this.startSync();
    }

    public boolean isLocal() {
        return false;
    }

    protected void finished() {
        if (this.startTime != Long.MIN_VALUE) {
            Keyspace.open((String)this.desc.keyspace).getColumnFamilyStore((String)this.desc.columnFamily).metric.repairSyncTime.update(System.currentTimeMillis() - this.startTime, TimeUnit.MILLISECONDS);
        }
    }

    public void abort() {
    }

    void sendRequest(SyncRequest request, InetAddressAndPort to) {
        RepairMessage.sendMessageWithFailureCB(request, Verb.SYNC_REQ, to, this::setException);
    }
}

