/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.collect.ImmutableMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;

abstract class AbstractCloudMetadataServiceConnector {
    protected final String metadataServiceUrl;

    protected AbstractCloudMetadataServiceConnector(String metadataServiceUrl) {
        this.metadataServiceUrl = metadataServiceUrl;
    }

    public String apiCall(String query) throws IOException {
        return this.apiCall(this.metadataServiceUrl, query, 200);
    }

    public String apiCall(String url, String query, int expectedResponseCode) throws IOException {
        return this.apiCall(url, query, "GET", ImmutableMap.of(), expectedResponseCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String apiCall(String url, String query, String method, Map<String, String> extraHeaders, int expectedResponseCode) throws IOException {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url + query).openConnection();
            extraHeaders.forEach(conn::setRequestProperty);
            conn.setRequestMethod(method);
            if (conn.getResponseCode() != expectedResponseCode) {
                throw new HttpException(conn.getResponseCode(), conn.getResponseMessage());
            }
            int cl = conn.getContentLength();
            if (cl == -1) {
                String string = null;
                return string;
            }
            byte[] b = new byte[cl];
            try (DataInputStream d = new DataInputStream((InputStream)conn.getContent());){
                d.readFully(b);
            }
            String string = new String(b, StandardCharsets.UTF_8);
            return string;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static final class HttpException
    extends IOException {
        public final int responseCode;
        public final String responseMessage;

        public HttpException(int responseCode, String responseMessage) {
            super("HTTP response code: " + responseCode + " (" + responseMessage + ')');
            this.responseCode = responseCode;
            this.responseMessage = responseMessage;
        }
    }
}

