/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;

public class TypeParser {
    private final String str;
    private int idx;
    private static volatile ImmutableMap<String, AbstractType<?>> cache = ImmutableMap.of();
    public static final TypeParser EMPTY_PARSER = new TypeParser("", 0);

    private TypeParser(String str, int idx) {
        this.str = str;
        this.idx = idx;
    }

    public TypeParser(String str) {
        this(str, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractType<?> parse(String str) throws SyntaxException, ConfigurationException {
        if (str == null) {
            return BytesType.instance;
        }
        AbstractType<?> type = cache.get(str);
        if (type != null) {
            return type;
        }
        int i = 0;
        int j = i = TypeParser.skipBlank(str, i);
        while (!TypeParser.isEOS(str, i) && TypeParser.isIdentifierChar(str.charAt(i))) {
            ++i;
        }
        if (i == j) {
            return BytesType.instance;
        }
        String name = str.substring(j, i);
        type = !TypeParser.isEOS(str, i = TypeParser.skipBlank(str, i)) && str.charAt(i) == '(' ? TypeParser.getAbstractType(name, new TypeParser(str, i)) : TypeParser.getAbstractType(name);
        Verify.verify(type != null, "Parsing %s yielded null, which is a bug", (Object)str);
        Class<TypeParser> clazz = TypeParser.class;
        synchronized (TypeParser.class) {
            if (!cache.containsKey(str)) {
                ImmutableMap.Builder<String, AbstractType<?>> builder = ImmutableMap.builder();
                builder.putAll(cache).put(str, type);
                cache = builder.build();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return type;
        }
    }

    public static AbstractType<?> parse(CharSequence compareWith) throws SyntaxException, ConfigurationException {
        return TypeParser.parse(compareWith == null ? null : compareWith.toString());
    }

    public AbstractType<?> parse() throws SyntaxException, ConfigurationException {
        this.skipBlank();
        String name = this.readNextIdentifier();
        this.skipBlank();
        if (!this.isEOS() && this.str.charAt(this.idx) == '(') {
            return TypeParser.getAbstractType(name, this);
        }
        return TypeParser.getAbstractType(name);
    }

    public Map<String, String> getKeyValueParameters() throws SyntaxException {
        if (this.isEOS()) {
            return Collections.emptyMap();
        }
        if (this.str.charAt(this.idx) != '(') {
            throw new IllegalStateException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ++this.idx;
        while (this.skipBlankAndComma()) {
            if (this.str.charAt(this.idx) == ')') {
                ++this.idx;
                return map;
            }
            String k = this.readNextIdentifier();
            String v = "";
            this.skipBlank();
            if (this.str.charAt(this.idx) == '=') {
                ++this.idx;
                this.skipBlank();
                v = this.readNextIdentifier();
            } else if (this.str.charAt(this.idx) != ',' && this.str.charAt(this.idx) != ')') {
                this.throwSyntaxError("unexpected character '" + this.str.charAt(this.idx) + "'");
            }
            map.put(k, v);
        }
        throw new SyntaxException(String.format("Syntax error parsing '%s' at char %d: unexpected end of string", this.str, this.idx));
    }

    public List<AbstractType<?>> getTypeParameters() throws SyntaxException, ConfigurationException {
        ArrayList list = new ArrayList();
        if (this.isEOS()) {
            return list;
        }
        if (this.str.charAt(this.idx) != '(') {
            throw new IllegalStateException();
        }
        ++this.idx;
        while (this.skipBlankAndComma()) {
            if (this.str.charAt(this.idx) == ')') {
                ++this.idx;
                return list;
            }
            try {
                list.add(this.parse());
            }
            catch (SyntaxException e) {
                SyntaxException ex = new SyntaxException(String.format("Exception while parsing '%s' around char %d", this.str, this.idx));
                ex.initCause(e);
                throw ex;
            }
        }
        throw new SyntaxException(String.format("Syntax error parsing '%s' at char %d: unexpected end of string", this.str, this.idx));
    }

    public Map<Byte, AbstractType<?>> getAliasParameters() throws SyntaxException, ConfigurationException {
        HashMap map = new HashMap();
        if (this.isEOS()) {
            return map;
        }
        if (this.str.charAt(this.idx) != '(') {
            throw new IllegalStateException();
        }
        ++this.idx;
        while (this.skipBlankAndComma()) {
            char aliasChar;
            if (this.str.charAt(this.idx) == ')') {
                ++this.idx;
                return map;
            }
            String alias = this.readNextIdentifier();
            if (alias.length() != 1) {
                this.throwSyntaxError("An alias should be a single character: '" + alias + "', string: " + this.str);
            }
            if ((aliasChar = alias.charAt(0)) < '!' || aliasChar > '\u007f') {
                this.throwSyntaxError("An alias should be a single character in [0..9a..bA..B-+._&]");
            }
            this.skipBlank();
            if (this.str.charAt(this.idx) != '=' || this.str.charAt(this.idx + 1) != '>') {
                this.throwSyntaxError("expecting '=>' token");
            }
            this.idx += 2;
            this.skipBlank();
            try {
                map.put((byte)aliasChar, this.parse());
            }
            catch (SyntaxException e) {
                SyntaxException ex = new SyntaxException(String.format("Exception while parsing '%s' around char %d", this.str, this.idx));
                ex.initCause(e);
                throw ex;
            }
        }
        throw new SyntaxException(String.format("Syntax error parsing '%s' at char %d: unexpected end of string", this.str, this.idx));
    }

    public Map<ByteBuffer, CollectionType> getCollectionsParameters() throws SyntaxException, ConfigurationException {
        HashMap<ByteBuffer, CollectionType> map = new HashMap<ByteBuffer, CollectionType>();
        if (this.isEOS()) {
            return map;
        }
        if (this.str.charAt(this.idx) != '(') {
            throw new IllegalStateException();
        }
        ++this.idx;
        while (this.skipBlankAndComma()) {
            if (this.str.charAt(this.idx) == ')') {
                ++this.idx;
                return map;
            }
            ByteBuffer bb = this.fromHex(this.readNextIdentifier());
            this.skipBlank();
            if (this.str.charAt(this.idx) != ':') {
                this.throwSyntaxError("expecting ':' token");
            }
            ++this.idx;
            this.skipBlank();
            try {
                AbstractType<?> type = this.parse();
                if (!(type instanceof CollectionType)) {
                    throw new SyntaxException(type + " is not a collection type");
                }
                map.put(bb, (CollectionType)type);
            }
            catch (SyntaxException e) {
                SyntaxException ex = new SyntaxException(String.format("Exception while parsing '%s' around char %d", this.str, this.idx));
                ex.initCause(e);
                throw ex;
            }
        }
        throw new SyntaxException(String.format("Syntax error parsing '%s' at char %d: unexpected end of string", this.str, this.idx));
    }

    private ByteBuffer fromHex(String hex) throws SyntaxException {
        try {
            return ByteBufferUtil.hexToBytes(hex);
        }
        catch (NumberFormatException e) {
            this.throwSyntaxError(e.getMessage());
            return null;
        }
    }

    public Pair<Pair<String, ByteBuffer>, List<Pair<ByteBuffer, AbstractType>>> getUserTypeParameters() throws SyntaxException, ConfigurationException {
        if (this.isEOS() || this.str.charAt(this.idx) != '(') {
            throw new IllegalStateException();
        }
        ++this.idx;
        this.skipBlankAndComma();
        String keyspace = this.readNextIdentifier();
        this.skipBlankAndComma();
        ByteBuffer typeName = this.fromHex(this.readNextIdentifier());
        ArrayList defs = new ArrayList();
        while (this.skipBlankAndComma()) {
            if (this.str.charAt(this.idx) == ')') {
                ++this.idx;
                return Pair.create(Pair.create(keyspace, typeName), defs);
            }
            ByteBuffer name = this.fromHex(this.readNextIdentifier());
            this.skipBlank();
            if (this.str.charAt(this.idx) != ':') {
                this.throwSyntaxError("expecting ':' token");
            }
            ++this.idx;
            this.skipBlank();
            try {
                AbstractType<?> type = this.parse();
                defs.add(Pair.create(name, type));
            }
            catch (SyntaxException e) {
                SyntaxException ex = new SyntaxException(String.format("Exception while parsing '%s' around char %d", this.str, this.idx));
                ex.initCause(e);
                throw ex;
            }
        }
        throw new SyntaxException(String.format("Syntax error parsing '%s' at char %d: unexpected end of string", this.str, this.idx));
    }

    private static AbstractType<?> getAbstractType(String compareWith) throws ConfigurationException {
        String className = compareWith.contains(".") ? compareWith : "org.apache.cassandra.db.marshal." + compareWith;
        Class typeClass = FBUtilities.classForName(className, "abstract-type");
        try {
            Field field = typeClass.getDeclaredField("instance");
            return (AbstractType)field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return TypeParser.getRawAbstractType(typeClass, EMPTY_PARSER);
        }
    }

    private static AbstractType<?> getAbstractType(String compareWith, TypeParser parser) throws SyntaxException, ConfigurationException {
        String className = compareWith.contains(".") ? compareWith : "org.apache.cassandra.db.marshal." + compareWith;
        Class typeClass = FBUtilities.classForName(className, "abstract-type");
        try {
            Method method = typeClass.getDeclaredMethod("getInstance", TypeParser.class);
            return (AbstractType)method.invoke(null, parser);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            AbstractType<?> type = TypeParser.getRawAbstractType(typeClass);
            return AbstractType.parseDefaultParameters(type, parser);
        }
        catch (InvocationTargetException e) {
            ConfigurationException ex = new ConfigurationException("Invalid definition for comparator " + typeClass.getName() + ".");
            ex.initCause(e.getTargetException());
            throw ex;
        }
    }

    private static AbstractType<?> getRawAbstractType(Class<? extends AbstractType<?>> typeClass) throws ConfigurationException {
        try {
            Field field = typeClass.getDeclaredField("instance");
            return (AbstractType)field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ConfigurationException("Invalid comparator class " + typeClass.getName() + ": must define a public static instance field or a public static method getInstance(TypeParser).");
        }
    }

    private static AbstractType<?> getRawAbstractType(Class<? extends AbstractType<?>> typeClass, TypeParser parser) throws ConfigurationException {
        try {
            Method method = typeClass.getDeclaredMethod("getInstance", TypeParser.class);
            return (AbstractType)method.invoke(null, parser);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ConfigurationException("Invalid comparator class " + typeClass.getName() + ": must define a public static instance field or a public static method getInstance(TypeParser).");
        }
        catch (InvocationTargetException e) {
            ConfigurationException ex = new ConfigurationException("Invalid definition for comparator " + typeClass.getName() + ".");
            ex.initCause(e.getTargetException());
            throw ex;
        }
    }

    private void throwSyntaxError(String msg) throws SyntaxException {
        throw new SyntaxException(String.format("Syntax error parsing '%s' at char %d: %s", this.str, this.idx, msg));
    }

    private boolean isEOS() {
        return TypeParser.isEOS(this.str, this.idx);
    }

    private static boolean isEOS(String str, int i) {
        return i >= str.length();
    }

    private static boolean isBlank(int c) {
        return c == 32 || c == 9 || c == 10;
    }

    private void skipBlank() {
        this.idx = TypeParser.skipBlank(this.str, this.idx);
    }

    private static int skipBlank(String str, int i) {
        while (!TypeParser.isEOS(str, i) && TypeParser.isBlank(str.charAt(i))) {
            ++i;
        }
        return i;
    }

    private boolean skipBlankAndComma() {
        boolean commaFound = false;
        while (!this.isEOS()) {
            char c = this.str.charAt(this.idx);
            if (c == ',') {
                if (commaFound) {
                    return true;
                }
                commaFound = true;
            } else if (!TypeParser.isBlank(c)) {
                return true;
            }
            ++this.idx;
        }
        return false;
    }

    private static boolean isIdentifierChar(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 45 || c == 43 || c == 46 || c == 95 || c == 38;
    }

    public String readNextIdentifier() {
        int i = this.idx;
        while (!this.isEOS() && TypeParser.isIdentifierChar(this.str.charAt(this.idx))) {
            ++this.idx;
        }
        return this.str.substring(i, this.idx);
    }

    public static String stringifyAliasesParameters(Map<Byte, AbstractType<?>> aliases) {
        Map.Entry<Byte, AbstractType<?>> entry;
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        Iterator<Map.Entry<Byte, AbstractType<?>>> iter2 = aliases.entrySet().iterator();
        if (iter2.hasNext()) {
            entry = iter2.next();
            sb.append((char)entry.getKey().byteValue()).append("=>").append(entry.getValue());
        }
        while (iter2.hasNext()) {
            entry = iter2.next();
            sb.append(',').append((char)entry.getKey().byteValue()).append("=>").append(entry.getValue());
        }
        sb.append(')');
        return sb.toString();
    }

    public static String stringifyTypeParameters(List<AbstractType<?>> types) {
        return TypeParser.stringifyTypeParameters(types, false);
    }

    public static String stringifyTypeParameters(List<AbstractType<?>> types, boolean ignoreFreezing) {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < types.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(types.get(i).toString(ignoreFreezing));
        }
        return sb.append(')').toString();
    }

    public static String stringifyCollectionsParameters(Map<ByteBuffer, ? extends CollectionType> collections) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        boolean first = true;
        for (Map.Entry<ByteBuffer, ? extends CollectionType> entry : collections.entrySet()) {
            if (!first) {
                sb.append(',');
            }
            first = false;
            sb.append(ByteBufferUtil.bytesToHex(entry.getKey())).append(":");
            sb.append(entry.getValue());
        }
        sb.append(')');
        return sb.toString();
    }

    public static String stringifyUserTypeParameters(String keysace, ByteBuffer typeName, List<FieldIdentifier> fields, List<AbstractType<?>> columnTypes, boolean ignoreFreezing) {
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(keysace).append(",").append(ByteBufferUtil.bytesToHex(typeName));
        for (int i = 0; i < fields.size(); ++i) {
            sb.append(',');
            sb.append(ByteBufferUtil.bytesToHex(fields.get((int)i).bytes)).append(":");
            sb.append(columnTypes.get(i).toString(ignoreFreezing));
        }
        sb.append(')');
        return sb.toString();
    }
}

