/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.ConfigurationLoader;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.config.Replaces;
import org.apache.cassandra.config.ReplacesList;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.composer.Composer;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.MissingProperty;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.Node;

public class YamlConfigurationLoader
implements ConfigurationLoader {
    private static final Logger logger = LoggerFactory.getLogger(YamlConfigurationLoader.class);
    private static final String DEFAULT_CONFIGURATION = "cassandra.yaml";
    private static URL storageConfigURL;

    private static URL getStorageConfigURL() throws ConfigurationException {
        URL url;
        block4: {
            String configUrl = System.getProperty("cassandra.config");
            if (configUrl == null) {
                configUrl = DEFAULT_CONFIGURATION;
            }
            try {
                url = new URL(configUrl);
                url.openStream().close();
            }
            catch (Exception e) {
                ClassLoader loader = DatabaseDescriptor.class.getClassLoader();
                url = loader.getResource(configUrl);
                if (url != null) break block4;
                String required = "file:" + File.separator + File.separator;
                if (!configUrl.startsWith(required)) {
                    throw new ConfigurationException(String.format("Expecting URI in variable: [cassandra.config]. Found[%s]. Please prefix the file with [%s%s] for local files and [%s<server>%s] for remote files. If you are executing this from an external tool, it needs to set Config.setClientMode(true) to avoid loading configuration.", configUrl, required, File.separator, required, File.separator));
                }
                throw new ConfigurationException("Cannot locate " + configUrl + ".  If this is a local file, please confirm you've provided " + required + File.separator + " as a URI prefix.");
            }
        }
        logger.info("Configuration location: {}", (Object)url);
        return url;
    }

    @Override
    public Config loadConfig() throws ConfigurationException {
        if (storageConfigURL == null) {
            storageConfigURL = YamlConfigurationLoader.getStorageConfigURL();
        }
        return this.loadConfig(storageConfigURL);
    }

    public Config loadConfig(URL url) throws ConfigurationException {
        try {
            byte[] configBytes;
            logger.debug("Loading settings from {}", (Object)url);
            try (InputStream is = url.openStream();){
                configBytes = ByteStreams.toByteArray(is);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            CustomConstructor constructor = new CustomConstructor(Config.class, Yaml.class.getClassLoader());
            Map<Class<?>, Map<String, Replacement>> replacements = YamlConfigurationLoader.getNameReplacements(Config.class);
            PropertiesChecker propertiesChecker = new PropertiesChecker(replacements);
            constructor.setPropertyUtils(propertiesChecker);
            Yaml yaml = new Yaml(constructor);
            Config result = YamlConfigurationLoader.loadConfig(yaml, configBytes);
            propertiesChecker.check();
            return result;
        }
        catch (YAMLException e) {
            throw new ConfigurationException("Invalid yaml: " + url + SystemUtils.LINE_SEPARATOR + " Error: " + e.getMessage(), false);
        }
    }

    @VisibleForTesting
    public static <T> T fromMap(Map<String, Object> map, Class<T> klass) {
        return YamlConfigurationLoader.fromMap(map, true, klass);
    }

    public static <T> T fromMap(Map<String, Object> map, boolean shouldCheck, Class<T> klass) {
        CustomConstructor constructor = new CustomConstructor(klass, klass.getClassLoader());
        Map<Class<?>, Map<String, Replacement>> replacements = YamlConfigurationLoader.getNameReplacements(Config.class);
        PropertiesChecker propertiesChecker = new PropertiesChecker(replacements);
        constructor.setPropertyUtils(propertiesChecker);
        Yaml yaml = new Yaml(constructor);
        final Node node = yaml.represent(map);
        constructor.setComposer(new Composer(null, null){

            @Override
            public Node getSingleNode() {
                return node;
            }
        });
        Object value = constructor.getSingleData(klass);
        if (shouldCheck) {
            propertiesChecker.check();
        }
        return (T)value;
    }

    private static Config loadConfig(Yaml yaml, byte[] configBytes) {
        Config config = yaml.loadAs(new ByteArrayInputStream(configBytes), Config.class);
        return config == null ? new Config() : config;
    }

    private static Map<Class<?>, Map<String, Replacement>> getNameReplacements(Class<?> klass) {
        List<Replacement> replacements = YamlConfigurationLoader.getReplacements(klass);
        HashMap objectOldNames = new HashMap();
        for (Replacement r : replacements) {
            Map oldNames = objectOldNames.computeIfAbsent(r.parent, ignore -> new HashMap());
            if (!oldNames.containsKey(r.oldName)) {
                oldNames.put(r.oldName, r);
                continue;
            }
            throw new ConfigurationException("Invalid annotations, you have more than one @Replaces annotation in Config class with same old name(" + r.oldName + ") defined.");
        }
        return objectOldNames;
    }

    private static List<Replacement> getReplacements(Class<?> klass) {
        ArrayList<Replacement> replacements = new ArrayList<Replacement>();
        for (Field field : klass.getDeclaredFields()) {
            String newName = field.getName();
            ReplacesList[] byType = (ReplacesList[])field.getAnnotationsByType(ReplacesList.class);
            if (byType == null || byType.length == 0) {
                Replaces r = field.getAnnotation(Replaces.class);
                if (r == null) continue;
                YamlConfigurationLoader.addReplacement(klass, replacements, newName, r);
                continue;
            }
            for (ReplacesList replacesList : byType) {
                for (Replaces r : replacesList.value()) {
                    YamlConfigurationLoader.addReplacement(klass, replacements, newName, r);
                }
            }
        }
        return replacements.isEmpty() ? Collections.emptyList() : replacements;
    }

    private static void addReplacement(Class<?> klass, List<Replacement> replacements, String newName, Replaces r) {
        String oldName = r.oldName();
        boolean deprecated = r.deprecated();
        replacements.add(new Replacement(klass, oldName, newName, deprecated));
    }

    static final class Replacement {
        final Class<?> parent;
        final String oldName;
        final String newName;
        final boolean deprecated;

        Replacement(Class<?> parent, String oldName, String newName, boolean deprecated) {
            this.parent = Objects.requireNonNull(parent);
            this.oldName = Objects.requireNonNull(oldName);
            this.newName = Objects.requireNonNull(newName);
            this.deprecated = deprecated;
        }
    }

    private static class PropertiesChecker
    extends PropertyUtils {
        private final Set<String> missingProperties = new HashSet<String>();
        private final Set<String> nullProperties = new HashSet<String>();
        private final Set<String> deprecationWarnings = new HashSet<String>();
        private final Map<Class<?>, Map<String, Replacement>> replacements;

        public PropertiesChecker(Map<Class<?>, Map<String, Replacement>> replacements) {
            this.replacements = Objects.requireNonNull(replacements, "Replacements should not be null");
            this.setSkipMissingProperties(true);
        }

        @Override
        public Property getProperty(Class<? extends Object> type, String name) {
            Property result;
            Map typeReplacements = this.replacements.getOrDefault(type, Collections.emptyMap());
            if (typeReplacements.containsKey(name)) {
                Replacement replacement = (Replacement)typeReplacements.get(name);
                final Property newProperty = super.getProperty(type, replacement.newName);
                result = new Property(replacement.oldName, newProperty.getType()){

                    @Override
                    public Class<?>[] getActualTypeArguments() {
                        return newProperty.getActualTypeArguments();
                    }

                    @Override
                    public void set(Object o, Object o1) throws Exception {
                        newProperty.set(o, o1);
                    }

                    @Override
                    public Object get(Object o) {
                        return newProperty.get(o);
                    }

                    @Override
                    public List<Annotation> getAnnotations() {
                        return null;
                    }

                    @Override
                    public <A extends Annotation> A getAnnotation(Class<A> aClass) {
                        return null;
                    }
                };
                if (replacement.deprecated) {
                    this.deprecationWarnings.add(replacement.oldName);
                }
            } else {
                result = super.getProperty(type, name);
            }
            if (result instanceof MissingProperty) {
                this.missingProperties.add(result.getName());
            }
            return new Property(result.getName(), result.getType()){

                @Override
                public void set(Object object, Object value) throws Exception {
                    if (value == null && this.get(object) != null) {
                        nullProperties.add(this.getName());
                    }
                    result.set(object, value);
                }

                @Override
                public Class<?>[] getActualTypeArguments() {
                    return result.getActualTypeArguments();
                }

                @Override
                public Object get(Object object) {
                    return result.get(object);
                }

                @Override
                public List<Annotation> getAnnotations() {
                    return Collections.EMPTY_LIST;
                }

                @Override
                public <A extends Annotation> A getAnnotation(Class<A> aClass) {
                    return null;
                }
            };
        }

        public void check() throws ConfigurationException {
            if (!this.nullProperties.isEmpty()) {
                throw new ConfigurationException("Invalid yaml. Those properties " + this.nullProperties + " are not valid", false);
            }
            if (!this.missingProperties.isEmpty()) {
                throw new ConfigurationException("Invalid yaml. Please remove properties " + this.missingProperties + " from your cassandra.yaml", false);
            }
            if (!this.deprecationWarnings.isEmpty()) {
                logger.warn("{} parameters have been deprecated. They have new names; For more information, please refer to NEWS.txt", this.deprecationWarnings);
            }
        }
    }

    static class CustomConstructor
    extends CustomClassLoaderConstructor {
        CustomConstructor(Class<?> theRoot, ClassLoader classLoader) {
            super(theRoot, classLoader);
            TypeDescription seedDesc = new TypeDescription(ParameterizedClass.class);
            seedDesc.putMapPropertyType("parameters", String.class, String.class);
            this.addTypeDescription(seedDesc);
        }

        @Override
        protected List<Object> createDefaultList(int initSize) {
            return Lists.newCopyOnWriteArrayList();
        }

        @Override
        protected Map<Object, Object> createDefaultMap(int initSize) {
            return Maps.newConcurrentMap();
        }

        @Override
        protected Set<Object> createDefaultSet(int initSize) {
            return Sets.newConcurrentHashSet();
        }
    }
}

