/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.schemastore;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.cassandra.cdc.schemastore.SchemaStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTableSchemaStore
implements SchemaStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalTableSchemaStore.class);
    private final Map<String, Schema> cache = new HashMap<String, Schema>();
    private final Map<String, GenericDatumWriter<GenericRecord>> writers = new HashMap<String, GenericDatumWriter<GenericRecord>>();
    private final Map<String, GenericDatumReader<GenericRecord>> readers = new HashMap<String, GenericDatumReader<GenericRecord>>();

    public static LocalTableSchemaStore getInstance() {
        return Holder.INSTANCE;
    }

    protected LocalTableSchemaStore() {
        this.loadFromResource();
    }

    @Override
    public Schema getSchema(String namespace, String name) {
        return this.cache.get(namespace);
    }

    @Override
    public GenericDatumWriter<GenericRecord> getWriter(String namespace, String name) {
        return this.writers.get(namespace);
    }

    @Override
    public GenericDatumReader<GenericRecord> getReader(String namespace, String name) {
        return this.readers.get(namespace);
    }

    protected void loadFromResource() {
        FileSystem jarFs = null;
        try {
            Path path;
            URL url = this.getClass().getClassLoader().getResource("table_schemas");
            if (url == null) {
                throw new RuntimeException("Resource table_schemas not found");
            }
            URI schemas = url.toURI();
            if (schemas.getScheme().equals("jar")) {
                jarFs = FileSystems.newFileSystem(schemas, new HashMap());
                path = jarFs.getPath("table_schemas", new String[0]);
            } else {
                path = Paths.get(schemas);
            }
            try (Stream<Path> paths = Files.walk(path, 1, new FileVisitOption[0]);){
                Schema.Parser parser = new Schema.Parser();
                paths.forEach(p -> {
                    if (!p.toString().endsWith(".avsc")) {
                        return;
                    }
                    try {
                        InputStream is = Files.newInputStream(p, new OpenOption[0]);
                        Schema schema = parser.parse(is);
                        String key = schema.getNamespace();
                        LOGGER.info("Loading schema namespace={}", (Object)key);
                        this.cache.put(key, schema);
                        this.writers.put(key, (GenericDatumWriter<GenericRecord>)new GenericDatumWriter(schema));
                        this.readers.put(key, (GenericDatumReader<GenericRecord>)new GenericDatumReader(schema));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read from table_schemas", e);
        }
        finally {
            if (jarFs != null) {
                try {
                    jarFs.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close jar", e);
                }
            }
        }
    }

    private static class Holder {
        private static final LocalTableSchemaStore INSTANCE = new LocalTableSchemaStore();

        private Holder() {
        }
    }
}

