/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.msg.jdk;

import java.nio.ByteBuffer;
import org.apache.cassandra.spark.data.CqlField;
import org.jetbrains.annotations.Nullable;

public class Column {
    private final String name;
    private final CqlField.CqlType type;
    @Nullable
    private final Object value;

    public Column(String name, CqlField.CqlType type, @Nullable ByteBuffer buf) {
        this(name, type, buf == null ? null : type.deserializeToJavaType(buf));
    }

    public Column(String name, CqlField.CqlType type, @Nullable Object value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public String name() {
        return this.name;
    }

    public CqlField.CqlType type() {
        return this.type;
    }

    @Nullable
    public Object value() {
        return this.value;
    }

    public <T> T getAs(Class<T> tClass) {
        return this.value == null ? null : (T)tClass.cast(this.value);
    }

    public String toString() {
        return "\"" + this.name + "\": " + (String)(this.value == null ? "null" : "\"" + String.valueOf(this.value) + "\"");
    }
}

