/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.cassandra.bridge.CdcBridge;
import org.apache.cassandra.bridge.TokenRange;
import org.apache.cassandra.cdc.api.CassandraSource;
import org.apache.cassandra.cdc.api.CdcOptions;
import org.apache.cassandra.cdc.api.CommitLog;
import org.apache.cassandra.cdc.api.CommitLogProvider;
import org.apache.cassandra.cdc.msg.CdcEvent;
import org.apache.cassandra.cdc.scanner.CdcScannerBuilder;
import org.apache.cassandra.cdc.scanner.CdcStreamScanner;
import org.apache.cassandra.cdc.state.CdcState;
import org.apache.cassandra.cdc.stats.ICdcStats;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.apache.cassandra.spark.data.partitioner.NotEnoughReplicasException;
import org.apache.cassandra.spark.utils.AsyncExecutor;
import org.apache.cassandra.spark.utils.IOUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroBatchIterator
implements Iterator<CdcEvent>,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroBatchIterator.class);
    @Nullable
    protected final TokenRange tokenRange;
    protected final CdcScannerBuilder builder;
    protected final CdcStreamScanner scanner;
    private CdcEvent curr = null;
    private boolean exhausted = false;

    @VisibleForTesting
    public MicroBatchIterator(CdcBridge cdcBridge, CdcState startState, CassandraSource cassandraSource, Supplier<Set<String>> keyspaceSupplier, CdcOptions cdcOptions, AsyncExecutor asyncExecutor, CommitLogProvider commitLogProvider) {
        this(cdcBridge, 0, null, startState, cassandraSource, keyspaceSupplier, cdcOptions, asyncExecutor, commitLogProvider, ICdcStats.STUB);
    }

    public MicroBatchIterator(CdcBridge cdcBridge, int partitionId, @Nullable TokenRange tokenRange, CdcState startState, CassandraSource cassandraSource, Supplier<Set<String>> keyspaceSupplier, CdcOptions cdcOptions, AsyncExecutor asyncExecutor, CommitLogProvider commitLogProvider, ICdcStats stats) throws NotEnoughReplicasException {
        stats.watermarkerSize(startState.size());
        this.tokenRange = tokenRange;
        Map<CassandraInstance, List<CommitLog>> logs = commitLogProvider.logs(this.tokenRange).collect(Collectors.groupingBy(CommitLog::instance, Collectors.toList()));
        for (String keyspace : keyspaceSupplier.get()) {
            int minReplicas = cdcOptions.minimumReplicas(keyspace);
            if (logs.size() >= minReplicas) continue;
            LOGGER.debug("Insufficient replicas available keyspace={} requiredReplicas={} availableReplicas={}", new Object[]{keyspace, minReplicas, logs.size()});
            throw new NotEnoughReplicasException(cdcOptions.consistencyLevel(), tokenRange == null ? null : tokenRange.lowerEndpoint(), tokenRange == null ? null : tokenRange.upperEndpoint(), minReplicas, logs.size(), cdcOptions.dc());
        }
        this.builder = new CdcScannerBuilder(cdcBridge, partitionId, cdcOptions, stats, tokenRange, startState, asyncExecutor, false, logs, cassandraSource);
        this.scanner = this.builder.build();
        if (LOGGER.isTraceEnabled()) {
            CdcState endState = this.scanner.endState();
            endState.markers.values().forEach(marker -> LOGGER.trace("Next epoch marker epoch={} instance={} segmentId={} position={} partitionId={}", new Object[]{endState.epoch, marker.instance().nodeName(), marker.segmentId(), marker.position(), partitionId}));
        }
    }

    public CdcState endState() {
        return this.scanner.endState();
    }

    @Override
    public boolean hasNext() {
        if (this.exhausted) {
            return false;
        }
        if (this.curr != null) {
            return true;
        }
        try {
            if (this.scanner.next()) {
                this.curr = (CdcEvent)this.scanner.data();
            } else {
                this.exhausted = true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.curr != null;
    }

    @Override
    public CdcEvent next() {
        CdcEvent event = this.curr;
        this.curr = null;
        return event;
    }

    @Override
    public void close() {
        if (this.scanner != null) {
            IOUtils.closeQuietly((AutoCloseable)this.scanner);
        }
    }
}

