/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.complex;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.spark.data.CassandraTypes;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlType;
import org.apache.cassandra.spark.data.complex.CqlFrozen;
import org.apache.cassandra.spark.data.complex.CqlList;
import org.apache.cassandra.spark.data.complex.CqlMap;
import org.apache.cassandra.spark.data.complex.CqlSet;
import org.apache.cassandra.spark.data.complex.CqlTuple;

public abstract class CqlCollection
extends CqlType
implements CqlField.CqlCollection {
    public final List<CqlField.CqlType> types;
    private final int hashCode;

    CqlCollection(CqlField.CqlType type) {
        this(Collections.singletonList(type));
    }

    CqlCollection(CqlField.CqlType ... types) {
        this(Arrays.asList(types));
    }

    CqlCollection(List<CqlField.CqlType> types) {
        this.types = new ArrayList<CqlField.CqlType>(types);
        this.hashCode = Objects.hash(types.toArray());
    }

    @Override
    public AbstractType<?> dataType() {
        return this.dataType(true);
    }

    @Override
    public ByteBuffer serialize(Object value) {
        return this.serializer().serialize(value);
    }

    public boolean isSupported() {
        return true;
    }

    public static CqlCollection build(String name, CqlField.CqlType ... types) {
        return CqlCollection.build(CqlField.CqlType.InternalType.fromString((String)name), types);
    }

    public static CqlCollection build(CqlField.CqlType.InternalType internalType, CqlField.CqlType ... types) {
        if (types.length < 1 || types[0] == null) {
            throw new IllegalArgumentException("Collection type requires a non-null key data type");
        }
        switch (internalType) {
            case Set: {
                return CqlCollection.set(types[0]);
            }
            case List: {
                return CqlCollection.list(types[0]);
            }
            case Map: {
                if (types.length < 2 || types[1] == null) {
                    throw new IllegalArgumentException("Map collection type requires a non-null value data type");
                }
                return CqlCollection.map(types[0], types[1]);
            }
            case Tuple: {
                return CqlCollection.tuple(types);
            }
        }
        throw new IllegalArgumentException("Unknown collection type: " + String.valueOf(internalType));
    }

    public static CqlList list(CqlField.CqlType type) {
        return new CqlList(type);
    }

    public static CqlSet set(CqlField.CqlType type) {
        return new CqlSet(type);
    }

    public static CqlMap map(CqlField.CqlType keyType, CqlField.CqlType valueType) {
        return new CqlMap(keyType, valueType);
    }

    public static CqlTuple tuple(CqlField.CqlType ... types) {
        return new CqlTuple(types);
    }

    public int size() {
        return this.types.size();
    }

    public List<CqlField.CqlType> types() {
        return this.types;
    }

    public CqlField.CqlType type() {
        return this.type(0);
    }

    public CqlField.CqlType type(int position) {
        return this.types.get(position);
    }

    public CqlFrozen frozen() {
        return CqlFrozen.build(this);
    }

    public String cqlName() {
        return String.format("%s<%s>", this.internalType().name().toLowerCase(), this.types.stream().map(CqlField.CqlType::cqlName).collect(Collectors.joining(", ")));
    }

    public Set<CqlField.CqlUdt> udts() {
        return this.types.stream().map(CqlField.CqlType::udts).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public String toString() {
        return this.cqlName();
    }

    public static CqlCollection read(CqlField.CqlType.InternalType internalType, Input input, CassandraTypes cassandraTypes) {
        int numTypes = input.readInt();
        CqlField.CqlType[] types = new CqlField.CqlType[numTypes];
        for (int type = 0; type < numTypes; ++type) {
            types[type] = CqlField.CqlType.read((Input)input, (CassandraTypes)cassandraTypes);
        }
        return CqlCollection.build(internalType, types);
    }

    public void write(Output output) {
        CqlField.CqlType.write((CqlField.CqlType)this, (Output)output);
        output.writeInt(this.types.size());
        for (CqlField.CqlType type : this.types) {
            type.write(output);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        CqlCollection that = (CqlCollection)other;
        return this.internalType() == that.internalType() && Objects.equals(this.types, that.types);
    }
}

